<?php

if (!defined("WHMCS")) {
    exit("This file cannot be accessed directly");
}

use WHMCS\Database\Capsule;

ob_start();
include "token.php";
$GLOBALS["license_token"] = ob_get_clean();
$licensing = DI::make("license");
function syslicensing_MetaData()
{
    return ["DisplayName" => "SysLic Licensing System", "APIVersion" => "3.13", "RequiresServer" => false];
}
function syslicensing_TestConnection($params)
{
    if (empty($params["serveraccesshash"])) {
        return "Wrong ServerHash";
    }
}
function get_softwares()
{
    $ch = curl_init();
    $args = http_build_query(["token" => $GLOBALS["license_token"]]);
    curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/getsoftwares?" . $args);
    curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    return json_decode($res, true);
}
function syslicensing_ConfigOptions()
{
    $id = App::getFromRequest("id");
    $addonsCollection = WHMCS\Database\Capsule::table("tbladdons")->orderBy("weight", "asc")->orderBy("name", "asc")->get();
    $supportUpdateAddons = [];
    $supportUpdateAddons[0] = "None";
    $softwares = get_softwares();
    foreach ($softwares as $software) {
        $supportUpdateAddons[$software["key"]] = $software["name"];
    }
    foreach ($addonsCollection as $addon) {
        $addonId = $addon->id;
        $addonName = str_replace(",", "&comma;", $addon->name);
        $addonPackages = explode(",", $addon->packages);
        if (in_array($id, $addonPackages)) {
            $supportUpdateAddons[$addonId] = $addonName;
        }
    }
    $configarray = ["Products" => ["Type" => "dropdown", "Options" => $supportUpdateAddons]];
    return $configarray;
}
function syslicensing_genkey($length, $prefix)
{
    if (!$length) {
        $length = 10;
    }
    $seeds = "abcdef0123456789";
    $key = NULL;
    $seeds_count = strlen($seeds) - 1;
    for ($i = 0; $i < $length; $i++) {
        $key .= $seeds[rand(0, $seeds_count)];
    }
    $licensekey = $prefix . $key;
    $result = select_query("mod_licensing", "COUNT(*)", ["licensekey" => $licensekey]);
    $data = mysql_fetch_array($result);
    if ($data[0]) {
        $licensekey = syslicensing_genkey($length, $prefix);
    }
    return $licensekey;
}
function syslicensing_CreateAccount($params)
{
    global $license_token;
    if (!array_key_exists("IP", $params["customfields"])) {
        return "Ip Null!";
    }
    if (empty($params["customfields"]["IP"])) {
        return "Ip Empty!";
    }
    $result = select_query("mod_licensing", "COUNT(*)", ["serviceid" => $params["serviceid"]]);
    $results = select_query("tblhosting", "*", ["orderid" => $params["model"]["orderid"]]);
    $data = mysql_fetch_array($result);
    $results = mysql_fetch_array($results);
    $month = 1;
    $trial = 7;
    $addonbillingcycle = $results["billingcycle"];
    if ($data[0]) {
        return "A license has already been generated for this item";
    }
    if ($addonbillingcycle == "Monthly") {
        $month = 1;
    } else {
        if ($addonbillingcycle == "Quarterly") {
            $month = 3;
        } else {
            if ($addonbillingcycle == "Semi-Annually") {
                $month = 6;
            } else {
                if ($addonbillingcycle == "Annually") {
                    $month = 12;
                } else {
                    if ($addonbillingcycle == "Biennially") {
                        $month = 24;
                    } else {
                        if ($addonbillingcycle == "Free") {
                            $trial = 7;
                        } else {
                            $month = 1;
                        }
                    }
                }
            }
        }
    }
    $length = "7";
    $productname = $params["configoption1"];
    $prefix = $productname . "-";
    $licensekey = syslicensing_genkey($length, $prefix);
    if ($addonbillingcycle == "Free Account") {
        $ch = curl_init();
        $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["trial" => $trial, "key" => $productname, "license_key" => $licensekey, "ip" => $params["customfields"]["IP"]]);
        curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/trial?" . $args);
        curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($ch);
        if (json_decode($res)->status == "success") {
            update_query("tblhosting", ["domainstatus" => "Active"], ["id" => $params["serviceid"]]);
            insert_query("mod_licensing", ["serviceid" => $params["serviceid"], "licensekey" => $licensekey, "validdomain" => "", "validip" => $params["customfields"]["IP"], "validdirectory" => "", "reissues" => "0", "status" => "Active"]);
            updateService(["domain" => $params["customfields"]["IP"], "username" => "", "password" => $licensekey]);
            $addonid = explode("|", $params["configoption7"]);
            $addonid = $addonid[0];
            if ($addonid) {
                $result = select_query("tblhosting", "orderid,paymentmethod", ["id" => $params["serviceid"]]);
                $data = mysql_fetch_array($result);
                $orderid = $data["orderid"];
                $paymentmethod = $data["paymentmethod"];
                $result = select_query("tbladdons", "", ["id" => $addonid]);
                $data = mysql_fetch_array($result);
                $addonname = $data["name"];
                $result = select_query("tblpricing", "", ["relid" => $addonid, "type" => "addon", "currency" => $params["clientsdetails"]["currency"]]);
                $data2 = mysql_fetch_array($result);
                $addonsetupfee = $data2["msetupfee"];
                $addonrecurring = $data2["monthly"];
                $addonbillingcycle = $data["billingcycle"];
                $addontax = $data["tax"];
                $nextduedate = date("Y-m-d", mktime(0, 0, 0, date("m"), date("d") + 7, date("Y")));
                insert_query("tblhostingaddons", ["orderid" => $orderid, "hostingid" => $params["serviceid"], "addonid" => $addonid, "setupfee" => $addonsetupfee, "recurring" => $addonrecurring, "billingcycle" => $addonbillingcycle, "tax" => $addontax, "status" => "Active", "nextduedate" => $nextduedate, "nextinvoicedate" => $nextduedate,  "termination_date" => $nextduedate, "paymentmethod" => $paymentmethod]);
            }
            return "success";
        }
    } else {
        $ch = curl_init();
        $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["month" => $month, "key" => $productname, "license_key" => $licensekey, "ip" => $params["customfields"]["IP"]]);
        curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/register?" . $args);
        curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($ch);
        if (json_decode($res)->status == "success") {
            update_query("tblhosting", ["domainstatus" => "Active"], ["id" => $params["serviceid"]]);
            insert_query("mod_licensing", ["serviceid" => $params["serviceid"], "licensekey" => $licensekey, "validdomain" => "", "validip" => $params["customfields"]["IP"], "validdirectory" => "", "reissues" => "0", "status" => "Active"]);
            updateService(["domain" => $params["customfields"]["IP"], "username" => "", "password" => $licensekey]);
            $addonid = explode("|", $params["configoption7"]);
            $addonid = $addonid[0];
            if ($addonid) {
                $result = select_query("tblhosting", "orderid,paymentmethod", ["id" => $params["serviceid"]]);
                $data = mysql_fetch_array($result);
                $orderid = $data["orderid"];
                $paymentmethod = $data["paymentmethod"];
                $result = select_query("tbladdons", "", ["id" => $addonid]);
                $data = mysql_fetch_array($result);
                $addonname = $data["name"];
                $result = select_query("tblpricing", "", ["relid" => $addonid, "type" => "addon", "currency" => $params["clientsdetails"]["currency"]]);
                $data2 = mysql_fetch_array($result);
                $addonsetupfee = $data2["msetupfee"];
                $addonrecurring = $data2["monthly"];
                $addonbillingcycle = $data["billingcycle"];
                $addontax = $data["tax"];
                if ($addonbillingcycle == "Monthly") {
                    $nextduedate = date("Y-m-d", mktime(0, 0, 0, date("m") + 1, date("d"), date("Y")));
                } else {
                    if ($addonbillingcycle == "Quarterly") {
                        $nextduedate = date("Y-m-d", mktime(0, 0, 0, date("m") + 3, date("d"), date("Y")));
                    } else {
                        if ($addonbillingcycle == "Semi-Annually") {
                            $nextduedate = date("Y-m-d", mktime(0, 0, 0, date("m") + 6, date("d"), date("Y")));
                        } else {
                            if ($addonbillingcycle == "Annually") {
                                $nextduedate = date("Y-m-d", mktime(0, 0, 0, date("m") + 12, date("d"), date("Y")));
                            } else {
                                if ($addonbillingcycle == "Biennially") {
                                    $nextduedate = date("Y-m-d", mktime(0, 0, 0, date("m") + 24, date("d"), date("Y")));
                                } else {
                                    $nextduedate = "0000-00-00";
                                }
                            }
                        }
                    }
                }
                insert_query("tblhostingaddons", ["orderid" => $orderid, "hostingid" => $params["serviceid"], "addonid" => $addonid, "setupfee" => $addonsetupfee, "recurring" => $addonrecurring, "billingcycle" => $addonbillingcycle, "tax" => $addontax, "status" => "Active", "nextduedate" => $nextduedate, "nextinvoicedate" => $nextduedate,  "termination_date" => $nextduedate, "paymentmethod" => $paymentmethod]);
            }
            return "success";
        }
    }
    return json_decode($res)->message;
}
function syslicensing_SuspendAccount($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    $existingLicense = syslicensing_does_license_exist($params);
    if (!$existingLicense) {
        return "No license exists for this item";
    }
    $productname = $params["configoption1"];
    $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["key" => $productname, "ip" => $params["customfields"]["IP"]]);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/deactivate?" . $args);
    curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    if (json_decode($res)->status == "success") {
        WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->update(["status" => "Suspended"]);
        return "success";
    }
    return json_decode($res)->message;
}
function syslicensing_UnsuspendAccount($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    $existingLicense = syslicensing_does_license_exist($params);
    if (!$existingLicense) {
        return "No license exists for this item";
    }
    $productname = $params["configoption1"];
    $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["key" => $productname, "ip" => $params["customfields"]["IP"]]);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/activate?" . $args);
    curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    if (json_decode($res)->status == "success") {
        WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->update(["status" => "Active"]);
        return "success";
    }
    return json_decode($res)->message;
}
function syslicensing_TerminateAccount($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    $existingLicense = syslicensing_does_license_exist($params);
    if (!$existingLicense) {
        return "No license exists for this item";
    }
    $productname = $params["configoption1"];
    $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["key" => $productname, "ip" => $params["customfields"]["IP"]]);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/delete?" . $args);
    curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    if (json_decode($res)->status == "success") {
        WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->update(["status" => "Expired"]);
        return "success";
    }
    return json_decode($res)->message;
}
function syslicensing_AdminCustomButtonArray()
{
    $buttonarray = ["Renew license" => "ReNew"];
    return $buttonarray;
}
function syslicensing_ClientAreaCustomButtonArray()
{
    $buttonarray = ["ChangeIp" => "ChangeIp"];
    return $buttonarray;
}
function syslicensing_revoke($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    $existingLicense = syslicensing_does_license_exist($params);
    if (!$existingLicense) {
        return "No license exists for this item";
    }
    WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->delete();
    updateService(["domain" => ""]);
    return "success";
}
function syslicensing_ReNew($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    $existingLicense = syslicensing_does_license_exist($params);
    if (!$existingLicense) {
        return "No license exists for this item";
    }
    $result = select_query("mod_licensing", "COUNT(*)", ["serviceid" => $params["serviceid"]]);
    $results = select_query("tblhosting", "*", ["orderid" => $params["model"]["orderid"]]);
    $data = mysql_fetch_array($result);
    $results = mysql_fetch_array($results);
    $addonbillingcycle = $results["billingcycle"];
    $end_at = $results["nextduedate"];
    if ($addonbillingcycle == "Monthly") {
        $month = 1;
    } else {
        if ($addonbillingcycle == "Quarterly") {
            $month = 3;
        } else {
            if ($addonbillingcycle == "Semi-Annually") {
                $month = 6;
            } else {
                if ($addonbillingcycle == "Annually") {
                    $month = 12;
                } else {
                    if ($addonbillingcycle == "Biennially") {
                        $month = 24;
                    } else {
                        $month = 1;
                    }
                }
            }
        }
    }
    $length = 7;
    $productname = $params["configoption1"];
    $prefix = $productname . "-";
    $licensekey = syslicensing_genkey($length, $prefix);
    $args = http_build_query(['token'=>$GLOBALS['license_token']] + ['billingcycle'=>$addonbillingcycle,'key'=>$productname,'ip'=>$params['customfields']['IP']]);
    $ch = curl_init();
    curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/renew?" . $args);
    curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $res = curl_exec($ch);
    if (json_decode($res)->status == "success") {
        $nextduedate = date('Y-m-d', strtotime($end_at . '+' . $month . ' month'));
        updateService(["domain" => $params["customfields"]["IP"], "username" => "", "password" => $licensekey]);
        try {
            $updatedUserCount = Capsule::table('tblhosting')
                ->where('orderid', $params['model']['orderid'])
                ->update(
                    [
                        'nextduedate' => $nextduedate,
                        'termination_date' => $nextduedate,
                        'nextinvoicedate' => $nextduedate

                    ]
                );
            return "success";
        } catch (\Exception $e) {
            return "Failed To Set Data!";
        }
        return "success";
    }
    return json_decode($res)->message;
}
function syslicensing_valid_input_clean($vals)
{
    $vals = explode(",", $vals);
    foreach ($vals as $k => $v) {
        $vals[$k] = trim($v, " \t\n\r");
    }
    return implode(",", $vals);
}
function syslicensing_AdminServicesTabFields($params)
{
    global $aInt;
    $license = syslicensing_get_license($params);
    if ($license) {
        $licenseId = $license->id;
        $validdomain = $license->validdomain;
        $validip = $license->validip;
        $validdirectory = $license->validdirectory;
        $reissues = $license->reissues;
        $status = $license->status;
        $lastAccess = $license->lastaccess;
        if ($lastAccess == "0000-00-00 00:00:00") {
            $lastAccess = "Never";
        } else {
            $lastAccess = fromMySQLDate($lastAccess, "time");
        }
        $statusoptions = "<option";
        if ($status == "Active") {
            $statusoptions .= " selected";
        }
        $statusoptions .= ">Active</option><option";
        if ($status == "Suspended") {
            $statusoptions .= " selected";
        }
        $statusoptions .= ">Suspended</option><option";
        if ($status == "Expired") {
            $statusoptions .= " selected";
        }
        $statusoptions .= ">Expired</option>";
        $licenseLogs = WHMCS\Database\Capsule::table("mod_licensinglog")->where("licenseid", "=", $licenseId)->orderBy("id", "DESC")->limit(10)->offset(0)->get();
        $tableData = [];
        foreach ($licenseLogs as $licenseLog) {
            $tableData[] = [fromMySQLDate($licenseLog->datetime, true), $licenseLog->domain, $licenseLog->ip, $licenseLog->path, $licenseLog->message];
        }
        $aInt->sortableTableInit("nopagination");
        $recentAccessLog = $aInt->sortableTable(["Date", "Domain", "IP", "Path", "Result"], $tableData);
        $fieldsArray = ["License Status" => "<select name=\"modulefields[3]\" id=\"licensestatus\" class=\"form-control select-inline\">" . $statusoptions . "</select>"];
        return $fieldsArray;
    } else {
        return [];
    }
}
function syslicensing_AdminServicesTabFieldsSave($params)
{
    update_query("mod_licensing", ["validdomain" => syslicensing_valid_input_clean($_POST["modulefields"][0]), "validip" => syslicensing_valid_input_clean($_POST["modulefields"][1]), "validdirectory" => syslicensing_valid_input_clean($_POST["modulefields"][2]), "status" => $_POST["modulefields"][3]], ["serviceid" => $params["serviceid"]]);
}
function syslicensing_ClientArea($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    $model = $params["model"];
    $licenseData = WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->first();
    $productName = $model instanceof WHMCS\Service\Addon ? $model->productAddon->name : $model->product->name;
    $licenseKey = $licenseData->licensekey;
    $validDomain = $licenseData->validdomain;
    $validIp = $params["customfields"]["IP"];
    if ($licenseData->validdirectory != "") {
        $validDirectory = $licenseData->validdirectory;
    } else {
        $productname = $params["configoption1"];
        $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["key" => $productname, "ip" => $params["customfields"]["IP"]]);
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/licenseinfo?" . $args);
        curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $res = curl_exec($ch);
        $validDirectory = json_decode($res)->cmd;
    }
    $status = $licenseData->status;
    $licenseCk = syslicensing_get_license($params);
    if ($model instanceof WHMCS\Service\Addon) {
        $allowReissues = (int) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption3")->first()->value;
        $allowDomainConflicts = (int) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption4")->first()->value;
        $allowIpConflicts = (int) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption5")->first()->value;
        $allowDirectoryConflicts = (int) $model->productAddon->moduleConfiguration()->where("setting_name", "=", "configoption6")->first()->value;
    } else {
        $allowReissues = (int) $model->product->moduleConfigOption3;
        $allowDomainConflicts = (int) $model->product->moduleConfigOption4;
        $allowIpConflicts = (int) $model->product->moduleConfigOption5;
        $allowDirectoryConflicts = (int) $model->product->moduleConfigOption6;
    }
    if (100 < $licenseCk->reissues) {
        $allowReissues = true;
    } else {
        $allowReissues = false;
    }
    return ["overrideDisplayTitle" => $productName, "overrideBreadcrumb" => [["clientarea.php?action=products&module=syslicensing", Lang::trans("licensingaddon.mylicenses")], ["clientarea.php?action=productdetails#", Lang::trans("licensingaddon.manageLicense")]], "tabOverviewReplacementTemplate" => "managelicense.tpl", "tabOverviewModuleOutputTemplate" => "licenseinfo.tpl", "templateVariables" => ["licensekey" => $licenseKey, "validdomain" => $validDomain, "validip" => $validIp, "validdirectory" => $validDirectory, "status" => $status, "allowreissues" => $allowReissues, "allowDomainConflicts" => $allowDomainConflicts, "allowIpConflicts" => $allowIpConflicts, "allowDirectoryConflicts" => $allowDirectoryConflicts]];
}
function syslicensing_ChangeIp($params)
{
    $license = syslicensing_get_license($params);
    if ($license->reissues < 100) {
        $productname = $params["configoption1"];
        if (isset($_POST["IPc"]) && $_POST["IPc"] != "" && $params["customfields"]["IP"] != $_POST["IPc"]) {
            $args = http_build_query(["token" => $GLOBALS["license_token"]] + ["key" => $productname, "ip" => $params["customfields"]["IP"], "ip_new" => $_POST["IPc"]]);
            $ch = curl_init();
            curl_setopt($ch, CURLOPT_URL, "https://cpanelseller.xyz/resellerapi/changeiplicense?" . $args);
            curl_setopt($ch, CURLOPT_USERAGENT, "SysLic");
            curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
            $res = curl_exec($ch);
            $ok = json_decode($res)->status;
            if ($ok == "success") {
                update_query("tblhosting", ["domain" => $_POST["IPc"]], ["id" => $params["serviceid"]]);
                update_query("tblcustomfieldsvalues", ["value" => $_POST["IPc"]], ["value" => $params["customfields"]["IP"], "relid" => $params["serviceid"]]);
                WHMCS\Database\Capsule::table("mod_licensing")->where("id", "=", $license->id)->increment("reissues", 100);
                return "success";
            }
            return json_decode($res)->message;
        }
        return "Error!";
    }
    return "Unk Ip!";
}
function syslicensing_does_license_exist($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    return WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->count();
}
function syslicensing_get_license($params)
{
    $addonId = array_key_exists("addonId", $params) && $params["addonId"] ? $params["addonId"] : 0;
    return WHMCS\Database\Capsule::table("mod_licensing")->where("serviceid", "=", $params["serviceid"])->where("addon_id", "=", $addonId)->first();
}
function syslicensing_get_expiry($params)
{
    return WHMCS\Database\Capsule::table("tblhosting")->where("orderid", "=", $params["orderid"])->first();
}
