<?php
/**
 * Jetpack Compatibility File
 * 
 * @category WordPress
 * @package  Hostiko
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://jetpack.com/
 * @since    1.0.0
 */

/**
 * Jetpack setup function.
 *
 * See: https://jetpack.com/support/infinite-scroll/
 * See: https://jetpack.com/support/responsive-videos/
 * See: https://jetpack.com/support/content-options/
 * 
 * @return void
 */
function Hostiko_Jetpack_setup() 
{
    // Add theme support for Infinite Scroll.
    add_theme_support(
        'infinite-scroll', 
        array(
            'container' => 'main',
            'render'    => 'Hostiko_Infinite_Scroll_render',
            'footer'    => 'page',
        ) 
    );

    // Add theme support for Responsive Videos.
    add_theme_support('jetpack-responsive-videos');

    // Add theme support for Content Options.
    add_theme_support(
        'jetpack-content-options', 
        array(
            'post-details' => array(
                'stylesheet' => 'hostiko-style',
                'date'       => '.posted-on',
                'categories' => '.cat-links',
                'tags'       => '.tags-links',
                'author'     => '.byline',
                'comment'    => '.comments-link',
            ),
        )
    );
}
add_action('after_setup_theme', 'Hostiko_Jetpack_setup');

/**
 * Custom render function for Infinite Scroll.
 * 
 * @return void
 */
function Hostiko_Infinite_Scroll_render() 
{
    while (have_posts()) {
        the_post();
        if (is_search()) :
            get_template_part('template-parts/content', 'search');
        else :
            get_template_part('template-parts/content', get_post_format());
        endif;
    }
}
