<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @category WordPress
 * @package  Hostiko
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://hostiko.com
 */

/**
 * Adds custom classes to the array of body classes.
 *
 * @param array $classes Classes for the body element.
 * 
 * @return array
 */
function Hostiko_Body_classes($classes) 
{
    // Adds a class of hfeed to non-singular pages.
    if (! is_singular()) {
        $classes[] = 'hfeed';
    }

    return $classes;
}
add_filter('body_class', 'Hostiko_Body_classes');

/**
 * Add a pingback url auto-discovery header for singularly identifiable articles.
 * 
 * @return void
 */
function Hostiko_Pingback_header() 
{
    if (is_singular() && pings_open()) {
        echo '<link rel="pingback" href="', esc_url(get_bloginfo('pingback_url')), '">';
    }
}
add_action('wp_head', 'Hostiko_Pingback_header');
