<?php
/**
 * * Template Name: Card-Blog-2
 *
 * This is the most generic template file in a WordPress theme
 * and one of the two required files for a theme (the other being style.css).
 * It is used to display a page when nothing more specific matches a query.
 * E.g., it puts together the home page when no home.php file exists.
 *
 * @category WordPress
 * @package  Mediplex
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://codex.wordpress.org/Template_Hierarchy
 */
$hostiko_redux_option = get_option('opt_theme_options');
get_header();
if (isset($hostiko_redux_option['constructionPage']) && $hostiko_redux_option['constructionPage'] && !is_user_logged_in()) {
    while (have_posts()) : the_post();
        get_template_part('template-parts/content', 'underconstruction');
        // If comments are open or we have at least one comment, load up the comment template.
        if (comments_open() || get_comments_number()) :
            comments_template();
        endif;
    endwhile; // End of the loop.
} else {
    if ('hostiko' == $hostiko_redux_option['headerstyle']) {
        $page_for_posts = get_option('page_for_posts');
        if (isset($hostiko_redux_option['showblogbanner']) && $hostiko_redux_option['showblogbanner']) {
            $post_banner_url=$hostiko_redux_option['blogbanner1']['url'];
        } else {
            $post_banner_url = get_the_post_thumbnail_url($page_for_posts, 'full');
        }
        ?>
</div>
    <div class="clearfix"></div>
    <div class="sub-banner text-center" 
        <?php if (isset($post_banner_url)) {
            echo 'style="background-image:url('.$post_banner_url.')"'; 
        }?> >
        <div class="display-table">
            <h1 class="white-color  text-uppercase semibold-font Poppins_font">
                <?php if (isset($hostiko_redux_option['showblogtitle'])&&$hostiko_redux_option['showblogtitle']) {
                    echo esc_html(isset($hostiko_redux_option['blogheading']) ? $hostiko_redux_option['blogheading'] : __('Default Blog Heading', 'hostiko'));
                } else {
                    $page_title = get_the_title($page_for_posts);
                    if (!empty($page_title)) {
                        echo esc_html($page_title); // Directly output dynamic title safely
                    } else {
                        echo esc_html__('Blog', 'hostiko'); // Fallback for translation
                    }
                }
                ?>
            </h1>
            <h6 class="breadcrumb white-color text-uppercase semibold-font Poppins_font"><?php Hostiko_Get_breadcrumb(); ?></h6>
        </div>
    </div>
    <div class="clearfix"></div>
    <div id="content1" class="site-content container">
    <?php } 
    $showsidebar = true;
    if (isset($_REQUEST['layout'])) {
        $layout=$_REQUEST['layout'];
        if ($layout=='full') {
            $showsidebar=false;
            $blogClass='col-lg-12 col-md-12 col-sm-12 col-xs-12 ';
        } else {
            $showsidebar=true;
            $blogClass='col-lg-8 col-md-8 col-sm-12 col-xs-12 ';
        }
    } else {
        if ($hostiko_redux_option['layoutblog1'] == 'full_layout') {
            $showsidebar=false;
            $layout='full';
            $blogClass='col-lg-12 col-md-12 col-sm-12 col-xs-12 ';
        } else {
            $showsidebar=true;
            $blogClass='col-lg-8 col-md-8 col-sm-12 col-xs-12 ';
        }
    }
    ?>
    <div id="primary" class="content-area  <?php echo $blogClass;?> <?php echo ($hostiko_redux_option['layoutblog1'] == 'left_layout' || $layout=='left' ? 'pull-right' : 'pull-left');
    ?>">
        <div id="content-card-blog">
            <?php 
            query_posts('post_type=post&post_status=publish&posts_per_page=10&paged=' . get_query_var('paged')); ?>
            <?php if (have_posts()) : ?>
                <?php $count = 0; ?>
                <?php while (have_posts()): the_post(); ?>
                    <?php $count++; ?>
                    <?php if (is_sticky() && is_home() && !is_paged()) {
                        ?>
                        <article class="blog-card <?php echo (isset($layout)&&$layout!='full'?'col-lg-6 col-md-6':'col-lg-4 col-md-4');?> col-sm-6 col-xs-12">
                            <div class="card">
                            <header class="card__thumb">
                                <a href="<?php the_permalink(); ?>"  class="overlay-icon" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('blog-img'); ?></a>

                            </header>
                            <div class="card__date">
                                <span class="card__date__day"><?php echo get_the_date('j'); ?></span>
                                <span class="card__date__month"><?php echo get_the_date('M');?></span>
                            </div>
                            <div class="card__body">
                                <?php $author = get_the_author();?>
                                <div class="card__category"><a href="<?php echo get_author_posts_url(get_the_author_meta('ID')) ?>"><?php echo esc_html('by '.$author); ?></a></div>
                                <?php the_title('<h2 class="card__title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>

                                <p class="card__description"><?php  echo esc_html(Hostiko_excerpt(40)); ?></p>
                            </div>
                            <footer class="card__footer">
                                <span class="icon icon--time"><a href="<?php the_permalink(); ?>"><?php echo esc_html(human_time_diff(get_the_time('U'), current_time('timestamp'))) . ' ago'; ?></a></span>
                                <span class="icon icon--comment"><a href="<?php the_permalink(); ?>"><?php comments_number('no comment', 'one comment', '% comments'); ?></a></span>
                            </footer>
                            </div>
                        </article>
                    <?php } else {?>
                        <article class="blog-card <?php echo (isset($layout)&&$layout!='full'?'col-lg-6 col-md-6':'col-lg-4 col-md-4');?> col-sm-6 col-xs-12">
                            <div class="card">
                                <header class="card__thumb">
                                    <a href="<?php the_permalink(); ?>"  class="overlay-icon" title="<?php the_title_attribute(); ?>"><?php the_post_thumbnail('full'); ?></a>
                                </header>
                                <div class="card__date">
                                    <span class="card__date__day"><?php echo get_the_date('j'); ?></span>
                                    <span class="card__date__month"><?php echo get_the_date('M');?></span>
                                </div>
                                <div class="card__body">
                                    <?php $author = get_the_author();?>
                                    <div class="card__category"><a href="<?php echo get_author_posts_url(get_the_author_meta('ID'))?>"><?php echo esc_html('by '.$author);?></a></div>
                                    <?php the_title('<h2 class="card__title"><a href="' . esc_url(get_permalink()) . '" rel="bookmark">', '</a></h2>'); ?>
                                    <p class="card__description"><?php  echo esc_html(Hostiko_excerpt(40));?></p>
                                </div>
                                <footer class="card__footer">
                                    <span class="icon icon--time"><a href="<?php the_permalink();?>"><?php echo esc_html(human_time_diff(get_the_time('U'), current_time('timestamp'))) .' ago'; ?></a></span>
                                    <span class="icon icon--comment"><a href="<?php the_permalink(); ?>"><?php comments_number('no comment', 'one comment', '% comments');?></a></span>
                                </footer>
                            </div>
                        </article>
                        <?php if (!isset($layout) || $layout!='full' ? $max=2 : $max=3);
                        if ($count == $max) { ?>
                            <div class="clearfix"></div>
                            <?php $count = 0; ?>
                            <?php 
                        } ?>
                            <?php 
                    }  
                endwhile;?>
                <div id="blog-nav"><?php Hostiko_Numeric_Posts_nav();?>
                </div>
            <?php else: ?>
                <div id="post-404" class="noposts">
                    <p><?php _e('None found.', 'hostiko'); ?></p>
                </div><!-- /#post-404 -->
            <?php endif;
            wp_reset_query(); ?>
        </div>
        </div>
    <?php
    if ($showsidebar==true) {
        ?>
    <div class="sidebar sidebar-blog col-lg-4 col-md-4 col-sm-12 col-xs-12 <?php echo ($hostiko_redux_option['layoutblog1']=='left_layout' || $layout=='left' ? 'pull-left' : 'pull-right');?>">
        <?php get_sidebar(); ?>
    </div>
    <?php }
}?>
</div><!--.site-content --><?php
    get_footer();