<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package Hostiko
 */
?>
<!doctype html>
<html <?php language_attributes(); ?>>

<head>
    <meta charset="<?php bloginfo( 'charset' ); ?>">
    <?php if ( is_singular() && pings_open( get_queried_object() ) ) : ?>
    <?php endif; ?>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>
    <?php
$style = '';
$is_preloader = get_theme_mod('show_preloader');

?>
    <script>
    document.addEventListener("DOMContentLoaded", function() {
        // Function to check if the page is being viewed in the Elementor editor
        function isElementorEditor() {
            return (
                window.location.href.indexOf("elementor") !== -1 &&
                document.querySelector(".elementor-editor-active") !== null
            );
        }

        // Hide the preloader if the page is viewed in the Elementor editor
        if (isElementorEditor()) {
            document.getElementById("preloader").style.display = "none";
        }
    });
    </script>
    <?php wp_body_open(); ?>
    <div id="page" class="site">
        <a class="skip-link screen-reader-text" href="#primary"><?php esc_html_e( 'Skip to content', 'hostiko' ); ?></a>
        <?php 
	$hostiko_show_header_button = get_theme_mod('hostiko_show_header_button');
    $btn_text_from_page = get_post_meta(get_the_ID(), 'button_text_from_page', true);
    if( $btn_text_from_page ){
        $btn_text = get_post_meta(get_the_ID(), 'button_text_from_page', true);
        $btn_link = get_post_meta(get_the_ID(), 'button_url_from_page', true);
    }else{
        $btn_text = get_theme_mod('hostiko_header_btn_text', 'free trial');
        $btn_link = get_theme_mod('hostiko_header_btn_link', '#');
    }
    // header-search
    // $show_header_search = get_theme_mod('hostiko_header_search_show', false);
    /** header topbar switcher **/
    $enable_header_topbar = get_theme_mod('hostiko_topbar_switch');
    // header_link
    $enable_investment_offer_link = get_theme_mod('hostiko_show_investment_offer_link');
    $enable_header_link_text = get_theme_mod('hostiko_header_link_text', esc_html__('Hostiko Offer', 'hostiko'));
    $enable_header_link_url = get_theme_mod('hostiko_header_link_url');
    // contact info
    $enable_show_contact_info = get_theme_mod('hostiko_show_contact_info');
    $contact_header_email = get_theme_mod('hostiko_header_email', esc_html__('info@gmail.com', 'hostiko'));
    $contact_header_phone = get_theme_mod('hostiko_header_phone', esc_html__('+97657945737', 'hostiko')); ?>
        <!-- navbar start -->
        <div
            class="navbar-area navbar-area-2 style-2 <?php if( empty($enable_header_topbar) ){ esc_attr_e("extra-margin-top", "hostiko") ; } ?>">
            <?php 
            $hostiko_show_header_button = get_theme_mod('hostiko_show_header_button');
            $btn_text_from_page = get_post_meta(get_the_ID(), 'button_text_from_page', true);
            if( $btn_text_from_page ){
                $btn_text = get_post_meta(get_the_ID(), 'button_text_from_page', true);
                $btn_link = get_post_meta(get_the_ID(), 'button_url_from_page', true);
            }else{
                $btn_text = get_theme_mod('hostiko_header_btn_text', 'free trial');
                $btn_link = get_theme_mod('hostiko_header_btn_link', '#');
            }
            // header-search
            // $show_header_search = get_theme_mod('hostiko_header_search_show', false);
            /** header topbar switcher **/
            $enable_header_topbar = get_theme_mod('hostiko_topbar_switch');
            // header_link
            $enable_investment_offer_link = get_theme_mod('hostiko_show_investment_offer_link');
            $enable_header_link_text = get_theme_mod('hostiko_header_link_text', esc_html__('Hostiko Offer', 'hostiko'));
            $enable_header_link_url = get_theme_mod('hostiko_header_link_url');
            // contact info
            $enable_show_contact_info = get_theme_mod('hostiko_show_contact_info');
            $contact_header_email = get_theme_mod('hostiko_header_email', esc_html__('info@gmail.com', 'hostiko'));
            $contact_header_phone = get_theme_mod('hostiko_header_phone', esc_html__('+97657945737', 'hostiko'));

            $akd_theme_admin_page = get_option( 'akd-framework-admin-page' );
            // var_dump($akd_theme_admin_page['opt-switcher-preloader']);
            
            
            // last nav child styling
            
            $get_live_chat_show = get_theme_mod('hostiko_show_live_chat_btn');
            $get_live_chat_txt = get_theme_mod('hostiko_live_chat_btn');
            $get_live_chat_bg = get_theme_mod('hostiko_live_bg');
            $get_live_chat_color = get_theme_mod('hostiko_live_color');
            $get_border_color_live_chat = get_theme_mod('hostiko_live_border');
            $get_border_radius_live_chat = get_theme_mod('hostiko_live_chat_br');
            $get_padding_live_chat = get_theme_mod('hostiko_live_chat_padding');
            $get_border_color_live_chat_hover = get_theme_mod('hostiko_live_border_hover');
            $get_live_chat_bg_hover = get_theme_mod('hostiko_live_bg_hover');
            $get_live_chat_color_hover = get_theme_mod('hostiko_live_color_hover');
            $get_hostiko_nav_border_bottom = get_theme_mod('hostiko_nav_border_bottom');
            $get_hostiko_nav_border_bottom_color = get_theme_mod('hostiko_nav_border_bottom_color');
            $get_hostiko_navbar_dropdown_position = get_theme_mod('hostiko_navbar_dropdown_position');
            $get_hostiko_hostiko_nav_hamburger_color = get_theme_mod('hostiko_nav_hamburger_color');
            $hostiko_breadcrumb_bg_color = get_theme_mod('breadcrumb_bg_color');
            $hostiko_breadcrumb_color = get_theme_mod('hostiko_breadcrumb_color');
            $hostiko_breadcrumb_hover_color = get_theme_mod('hostiko_breadcrumb_hover_color');
            $hostiko_breadcrumb_active_color = get_theme_mod('hostiko_breadcrumb_active_color');
            $hostiko_breadcrumb_br = get_theme_mod('hostiko_breadcrumb_br');
            $hostiko_breadcrumb_border_width = get_theme_mod('hostiko_breadcrumb_border_width');
            $hostiko_breadcrumb_border_color = get_theme_mod('hostiko_breadcrumb_border_color');
            $hostiko_breadcrumb_padding = get_theme_mod('hostiko_breadcrumb_padding');
            $get_enable_hostiko_customizer_settings = get_theme_mod('hostiko_enable_customizer_settings', 0);

            $hostiko_page_title_color = get_theme_mod('page_title_color');
            // if($get_enable_hostiko_customizer_settings == '1'){
            ?>
            <style>
            .page-title-area h1,
            .page-title-area .title,
            .page-title-area.style-1 div.text-center {
                <?php if ( !empty($hostiko_page_title_color)) {
                    ?>color: <?php echo esc_attr($hostiko_page_title_color);
                    ?> !important;
                    <?php
                }

                ?>
            }

            .page-title-area .breadcrumb {
                <?php if ( !empty($hostiko_breadcrumb_bg_color)) {
                    ?>background-color: <?php echo esc_attr($hostiko_breadcrumb_bg_color);
                    ?> !important;
                    <?php
                }

                ?><?php if ( !empty($hostiko_breadcrumb_color)) {
                    ?>color: <?php echo esc_attr($hostiko_breadcrumb_color);
                    ?> !important;
                    <?php
                }

                ?><?php if ( !empty($hostiko_breadcrumb_padding)) {
                    ?>padding: <?php echo esc_attr($hostiko_breadcrumb_padding);
                    ?> !important;
                    <?php
                }

                ?><?php if ( !empty($hostiko_breadcrumb_br)) {
                    ?>border-radius: <?php echo esc_attr($hostiko_breadcrumb_br);
                    ?> !important;
                    <?php
                }

                ?><?php if ( !empty($hostiko_breadcrumb_border_width) && !empty($hostiko_breadcrumb_border_color)) {
                    ?>border: <?php echo esc_attr($hostiko_breadcrumb_border_width);
                    ?>solid <?php echo esc_attr($hostiko_breadcrumb_border_color);
                    ?> !important;
                    <?php
                }

                ?>
            }

            .page-title-area .breadcrumb a,
            .breadcrumb li:not(:last-child)::after {
                <?php if ( !empty($hostiko_breadcrumb_color)) {
                    ?>color: <?php echo esc_attr($hostiko_breadcrumb_color);
                    ?> !important;
                    <?php
                }

                ?>
            }

            .breadcrumb li a:hover {
                <?php if ( !empty($hostiko_breadcrumb_hover_color)) {
                    ?>color: <?php echo esc_attr($hostiko_breadcrumb_hover_color);
                    ?> !important;
                    <?php
                }

                ?>
            }

            .page-title-area .breadcrumb .active {
                <?php if ( !empty($hostiko_breadcrumb_active_color)) {
                    ?>color: <?php echo esc_attr($hostiko_breadcrumb_active_color);
                    ?> !important;
                    <?php
                }

                ?>
            }
            </style>
            <?php
            if($get_live_chat_show && $get_live_chat_show == '1'){
            ?>
            <style>
            @media only screen and (min-width: 991px) {
                .navbar-area .nav-container .navbar-collapse .navbar-nav>li.menu-item:last-child {
                    <?php if ( !empty($get_live_chat_bg)) {
                        ?>background: <?php echo esc_attr($get_live_chat_bg);
                        ?> !important;
                        <?php
                    }

                    ?><?php if ( !empty($get_border_color_live_chat)) {
                        ?>border-color: <?php echo esc_attr($get_border_color_live_chat);
                        ?> !important;
                        <?php
                    }

                    ?><?php if ( !empty($get_border_radius_live_chat)) {
                        ?>border-radius: <?php echo esc_attr($get_border_radius_live_chat);
                        ?> !important;
                        <?php
                    }

                    ?><?php if ( !empty($get_padding_live_chat)) {
                        ?>padding: <?php echo esc_attr($get_padding_live_chat);
                        ?> !important;
                        <?php
                    }

                    ?>
                }

                .navbar-area.style-2 .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav > li:last-child > a {
                    <?php if ( !empty($get_live_chat_color)) {
                        ?>color: <?php echo esc_attr($get_live_chat_color);
                        ?> !important;
                        <?php
                    }

                    ?>
                }

                .navbar-area .nav-container .navbar-collapse .navbar-nav>li.menu-item:last-child:hover {
                    <?php if ( !empty($get_live_chat_bg_hover)) {
                        ?>background: <?php echo esc_attr($get_live_chat_bg_hover);
                        ?> !important;
                        <?php
                    }

                    ?><?php if ( !empty($get_border_color_live_chat_hover)) {
                        ?>border-color: <?php echo esc_attr($get_border_color_live_chat_hover);
                        ?> !important;
                        <?php
                    }

                    ?><?php if ( !empty($get_live_chat_color_hover)) {
                        ?>color: <?php echo esc_attr($get_live_chat_color_hover);
                        ?> !important;
                        <?php
                    }

                    ?>
                }

                .navbar-area.style-2 .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li:last-child a:hover{
                    <?php if ( !empty($get_live_chat_color_hover)) {
                        ?>color: <?php echo esc_attr($get_live_chat_color_hover);
                        ?> !important;
                        <?php
                    }

                    ?>
                }

                .nav-transparent .nav-container .navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu {
                    <?php if ( !empty($get_hostiko_navbar_dropdown_position)) {
                        ?>top: <?php echo esc_attr($get_hostiko_navbar_dropdown_position);
                        ?> !important;
                        <?php
                    }

                    ?>
                }
            }

            .navbar-expand-lg {
                <?php if ( !empty($get_hostiko_nav_border_bottom_color) && !empty($get_hostiko_nav_border_bottom)) {
                    ?>border-bottom: <?php echo esc_attr($get_hostiko_nav_border_bottom) .' solid'. esc_attr($get_hostiko_nav_border_bottom_color);
                    ?> !important;
                    <?php
                }

                ?>
            }

            .nav-transparent .toggle-btn .icon-left,
            .nav-transparent .toggle-btn .icon-right,
            .nav-transparent .toggle-btn .icon-left:before,
            .nav-transparent .toggle-btn .icon-left:after,
            .nav-transparent .toggle-btn .icon-right:before,
            .nav-transparent .toggle-btn .icon-right:after {
                <?php if ( !empty($get_hostiko_hostiko_nav_hamburger_color)) {
                    ?>background: <?php echo esc_attr($get_hostiko_hostiko_nav_hamburger_color);
                    ?> !important;
                    <?php
                }

                ?>
            }
            </style>
            <?php
            }
            // }
    
            $preLoader = get_theme_mod('hostiko_preloader_switch');
            if ($preLoader == true || (isset($akd_theme_admin_page['opt-switcher-preloader']) && $akd_theme_admin_page['opt-switcher-preloader'] == true)) :?>
            <style>
            <?php if(isset($akd_theme_admin_page['opt-switcher-preloader-bg']) && $akd_theme_admin_page['opt-switcher-preloader-bg'] !='') {
                ?>.preloader-inner {
                    background-color: <?php echo $akd_theme_admin_page['opt-switcher-preloader-bg'];
                    ?>;

                }

                <?php
            }

            ?><?php if(isset($akd_theme_admin_page['opt-select-preloader-img']) && $akd_theme_admin_page['opt-select-preloader-img'] !='') {
                ?>.spinner {
                    background-image: url('<?php echo $akd_theme_admin_page['opt-select-preloader-img'];?>');
                    background-size: contain;
                    background-position: center;

                }

                .spinner div {
                    display: none;
                }

                <?php
            }

            ?>
            </style>
            <?php
                if(isset($_GET['elementor-preview'])){
                ?>
            <div id='preloader' class='preloader' style="display:none;">
                <?php
                }
                else{
                    ?>
                <div id='preloader' class='preloader'>
                    <?php
                    }
                    ?>
                    <div class="preloader-inner">
                        <div class="spinner">
                            <div class="dot1"></div>
                            <div class="dot2"></div>
                        </div>
                    </div>
                </div>
                <?php endif;  ?>
                <div class="body-overlay" id="body-overlay"></div>
                <div class="search-popup" id="search-popup">
                    <?php get_search_form(); ?>
                </div>

                <?php 
                // Default header
                // $hostiko_header_type = get_theme_mod('choose_default_header');
                // $hostiko_header_type = $akd_theme_admin_page['opt-select-default-header'];
                $hostiko_header_type = isset($akd_theme_admin_page['opt-select-default-header']) ? $akd_theme_admin_page['opt-select-default-header'] : 'default-header';

                $hostiko_header_e = get_theme_mod('choose_elementor_header');
                if($hostiko_header_type && $hostiko_header_type != 'default-header' && $hostiko_header_e) {
                        echo Elementor\Plugin::instance()
                        ->frontend
                            ->get_builder_content_for_display($hostiko_header_e);   
                }
                else {
                    ?>
                <!-- navbar start -->
                <div
                    class="navbar-area navbar-area-2 style-2 <?php if( empty($enable_header_topbar) ){ esc_attr_e("extra-margin-top", "hostiko") ; } ?>">
                    <?php 
                        if($enable_header_topbar == true) :
                            $header_topbar_bg = get_theme_mod('hostiko_header_topbar_bg');
                        
                        ?>
                    <div class="navbar-top">
                        <div class="container">
                            <div class="row">
                                <div class="col-sm-7 text-sm-left text-center">
                                    <?php 
                                        if($enable_show_contact_info == true): ?>
                                    <ul class="topbar-left">
                                        <li class="topbar-single-info"><i class="fa fa-envelope"></i><a
                                                href="mailto:<?php echo esc_html($contact_header_email); ?>"><?php echo esc_html($contact_header_email); ?></a>
                                        </li>
                                        <li class="topbar-single-info ml-3 ml-lg-0"><i class="fa fa-phone"></i><a
                                                href='tel:<?php echo esc_html($contact_header_phone); ?>'></a><?php echo esc_html($contact_header_phone); ?>
                                        </li>
                                    </ul>
                                    <?php 
                                        endif; ?>
                                </div>
                                <div class="col-sm-5 text-sm-right text-center">
                                    <?php 
                                        if($enable_header_topbar == true) :?>
                                    <ul class="topbar-right float-md-right">
                                        <?php 
                                                if( $enable_investment_offer_link ): ?>
                                        <li class="topbar-single-info">
                                            <a href="<?php echo esc_html($enable_header_link_url); ?>"
                                                class="d-none d-lg-inline-block"><?php echo esc_html($enable_header_link_text); ?></a>
                                        </li>
                                        <?php 
                                                endif; ?>
                                        <?php hostiko_header_social_profiles(); ?>
                                        <?php hostiko_user_login(); ?>
                                    </ul>
                                    <?php 
                                        endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php 
                        endif; ?>
                    <nav class="navbar navbar-area navbar-expand-lg nav-transparent">
                        <div class="container nav-container nav-white">
                            <div class="responsive-mobile-menu">
                                <div class="logo">
                                    <?php echo hostiko_header_logo(); ?>
                                </div>
                                <button class="s7t-header-menu toggle-btn d-block d-lg-none" data-toggle="collapse"
                                    data-val="0" data-target="#hostiko_main_menu" aria-expanded="false"
                                    aria-label="<?php esc_attr_e('Toggle navigation','hostiko'); ?>">
                                    <span class="icon-left"></span>
                                    <span class="icon-right"></span>
                                </button>
                            </div>
                            <?php
                                    wp_nav_menu(array(
                                        'menu' => 'primary-menu',
                                        'theme_location' => 'main-menu',
                                        'menu_class' => 'navbar-nav',
                                        'container' => 'div',
                                        'container_class' => 'collapse navbar-collapse',
                                        'container_id' => 'hostiko_main_menu',
                                        'fallback_cb' => 'hostiko_theme_fallback_menu',
                                    ));
                                ?>
                            <?php

                                // Nav bar Styling

                                $get_nav_color = get_theme_mod('hostiko_nav_color');                
                                $get_nav_color_hover = get_theme_mod('hostiko_nav_hover_color');
                                $get_nav_color_active = get_theme_mod('hostiko_nav_active_color');
                                $get_nav_dropdown_bg = get_theme_mod('hostiko_nav_dropdown_bg');
                                $get_nav_dropdown_bg_hover = get_theme_mod('hostiko_nav_dropdown_bg_hover');
                                $get_nav_dropdown_color = get_theme_mod('hostiko_nav_dropdown_color');
                                $get_nav_dropdown_hover_color = get_theme_mod('hostiko_nav_dropdown_hover_color');

                                $get_hostiko_navbar_dropdown_br = get_theme_mod('hostiko_navbar_dropdown_br');
                                $get_dropdown_border_width = get_theme_mod('hostiko_dropdown_border_width');
                                $get_nav_dropdown_border_color = get_theme_mod('hostiko_nav_dropdown_border_color');
                                $get_nav_dropdown_bg_mobile = get_theme_mod('hostiko_nav_dropdown_bg_mobile');

                                $get_nav_dropdown_color_mobile = get_theme_mod('hostiko_nav_dropdown_color_mobile');

                                $get_nav_margin_bottom = get_theme_mod('hostiko_header_margin_bottom');

                                $get_nav_margin_bottom_mobile = get_theme_mod('hostiko_header_margin_bottom_mobile');

                                $get_nav_sticky_header = get_theme_mod('hostiko_sticky_header_btn');
                                $hostiko_stickyheader_bg = get_theme_mod('hostiko_stickyheader_bg', 'transparent');

                                $get_hostiko_header_bg = get_theme_mod('hostiko_header_bg');
                                
                                $get_hostiko_header_width = get_theme_mod('hostiko_header_width');

                                $get_nav_dropdown_color_hover_mobile = get_theme_mod('hostiko_nav_dropdown_color_hover_mobile');

                                ?>
                            <style>
                            .navbar-area {
                                <?php if ( !empty($get_nav_sticky_header) && ($get_nav_sticky_header==1)) {
                                    ?>z-index: 3;
                                    transition: top 5s linear;
                                    position: fixed !important;
                                    left: 0;
                                    right: 0;
                                    top: 0;
                                    box-shadow: 0px 0px 76px 0px rgba(194, 244, 255, 0.45);
                                    border-bottom: 1px solid var(--e-global-color-light-grayish-cyan);
                                    animation: slideDown 0.7s;

                                    <?php
                                }

                                ?>
                            }
                            </style>
                            <style>
                            .navbar-area .navbar {
                                <?php if ($hostiko_stickyheader_bg !='') {
                                    ?>background: <?=$hostiko_stickyheader_bg?>;
                                    <?php
                                }

                                ?>
                            }
                            
                            <?php if ( !empty($get_hostiko_header_width)) {
                                ?>.navbar-area .nav-container {
                                    max-width: <?php echo esc_attr($get_hostiko_header_width);
                                    ?> !important;
                                }

                                <?php
                            }

                            ?>.navbar-area .navbar {
                                <?php if ( !empty($get_hostiko_header_bg)) {
                                    ?>background: <?php echo esc_attr($get_hostiko_header_bg);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area {
                                <?php if ( !empty($get_nav_sticky_header) && ($get_nav_sticky_header==1)) {
                                    ?>z-index: 3;
                                    transition: top 5s linear;
                                    position: fixed !important;
                                    left: 0;
                                    right: 0;
                                    top: 0;
                                    box-shadow: 0px 0px 76px 0px rgba(194, 244, 255, 0.45);
                                    border-bottom: 1px solid var(--e-global-color-light-grayish-cyan);
                                    animation: slideDown 0.7s;

                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .navbar {
                                <?php if ( !empty($get_nav_margin_bottom)) {
                                    ?>margin-bottom: <?php echo esc_attr($get_nav_margin_bottom);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav>li>a,
                            .nav-white .nav-container .navbar-collapse .navbar-nav>li>a,
                            .navbar-area .nav-container .navbar-collapse .navbar-nav .menu-item-has-children a:first-child::before {
                                <?php if ( !empty($get_nav_color)) {
                                    ?>color: <?php echo esc_attr($get_nav_color);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area.style-2 .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li:hover a,
                            .navbar-area.style-2 .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li a:hover,
                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav .menu-item-has-children:hover a:first-child::before {
                                <?php if ( !empty($get_nav_color_hover)) {
                                    ?>color: <?php echo esc_attr($get_nav_color_hover);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .nav-transparent .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav>li.menu-item-has-children li.current-menu-item a,
                            .navbar-area .nav-transparent .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.current-menu-ancestor>a,
                            .navbar-area .nav-transparent .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.current-menu-ancestor .sub-menu>a,
                            .navbar-area .nav-transparent .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.current-menu-ancestor>a:before {
                                <?php if ( !empty($get_nav_color_active)) {
                                    ?>color: <?php echo esc_attr($get_nav_color_active);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu,
                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li,
                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li a {
                                <?php if ( !empty($get_nav_dropdown_bg)) {
                                    ?>background-color: <?php echo esc_attr($get_nav_dropdown_bg);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            #hostiko_main_menu .sub-menu {

                                <?php if ( !empty($get_hostiko_navbar_dropdown_br)) {
                                    ?>border-radius: <?php echo esc_attr($get_hostiko_navbar_dropdown_br);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_nav_dropdown_border_color) && !empty($get_dropdown_border_width)) {
                                    ?>border: <?php echo esc_attr($get_dropdown_border_width) .' solid'. esc_attr($get_nav_dropdown_border_color);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li a {
                                <?php if ( !empty($get_nav_dropdown_bg_hover)) {
                                    ?>background-color: <?php echo esc_attr($get_nav_dropdown_bg_hover);
                                    ?> !important;
                                    <?php
                                }
                            
                                ?>
                            }
                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li:hover a{  
                                <?php if ( !empty($get_nav_dropdown_hover_color)) {
                                    ?>color: <?php echo esc_attr($get_nav_dropdown_hover_color);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li a {
                                <?php if ( !empty($get_nav_dropdown_color)) {
                                    ?>color: <?php echo esc_attr($get_nav_dropdown_color);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu,
                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li,
                            .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav li.menu-item-has-children .sub-menu li a {
                                <?php if ( !empty($get_nav_dropdown_bg)) {
                                    ?>background-color: <?php echo esc_attr($get_nav_dropdown_bg);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            @media only screen and (max-width:991px) {

                                body .expand_close #hostiko_main_menu.show,
                                #hostiko_main_menu.navbar-collapse,
                                .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav {
                                    <?php if ( !empty($get_nav_dropdown_bg_mobile)) {
                                        ?>background-color: <?php echo esc_attr($get_nav_dropdown_bg_mobile);
                                        ?> !important;
                                        <?php
                                    }

                                    ?>
                                }

                                .navbar .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav>li>a,
                                .nav-white .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav>li>a,
                                .navbar-area .nav-container #hostiko_main_menu.navbar-collapse .navbar-nav .menu-item-has-children a:first-child::before {
                                    <?php if ( !empty($get_nav_dropdown_color_mobile)) {
                                        ?>color: <?php echo esc_attr($get_nav_dropdown_color_mobile);
                                        ?> !important;
                                        <?php
                                    }

                                    ?>
                                }
                            }

                            @media only screen and (max-width:767px) {
                                .navbar-area .navbar {
                                    <?php if ( !empty($get_nav_margin_bottom_mobile)) {
                                        ?>margin-bottom: <?php echo esc_attr($get_nav_margin_bottom_mobile);
                                        ?> !important;
                                        <?php
                                    }

                                    ?>
                                }
                            }
                            </style>
                            <?php
                                    

                                // Cart Icon Styling

                                $get_cart_icon_show = get_theme_mod('hostiko_show_cart_icon_btn', 1);
                                $get_cart_icon_bg = get_theme_mod('hostiko_cart_icon_bg');
                                $get_cart_icon_color = get_theme_mod('hostiko_cart_icon_color');
                                $get_border_color_cart_icon = get_theme_mod('hostiko_cart_icon_border');
                                $get_border_radius_cart_icon = get_theme_mod('hostiko_cart_icon_br');
                                $get_padding_cart_icon = get_theme_mod('hostiko_cart_icon_padding');

                                $get_border_color_cart_icon_hover = get_theme_mod('hostiko_cart_icon_border_hover');
                                $get_cart_icon_bg_hover = get_theme_mod('hostiko_cart_icon_bg_hover');
                                $get_cart_icon_color_hover = get_theme_mod('hostiko_cart_icon_color_hover');


                                // Cart Counter Styling

                                $get_cart_counter_top = get_theme_mod('hostiko_cart_counter_top');
                                $get_cart_counter_right = get_theme_mod('hostiko_cart_counter_right');
                                $get_cart_counter_bg = get_theme_mod('hostiko_cart_counter_bg');
                                $get_cart_counter_color = get_theme_mod('hostiko_cart_counter_color');
                                
                                if($get_cart_icon_show && $get_cart_icon_show == 1){
                                    ?>
                            <style>
                            .navbar-area .navbar-area-2 .cart-btn i {
                                <?php if ( !empty($get_cart_icon_bg)) {
                                    ?>background: <?php echo esc_attr($get_cart_icon_bg);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_border_color_cart_icon)) {
                                    ?>border: 1px solid <?php echo esc_attr($get_border_color_cart_icon);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_border_radius_cart_icon)) {
                                    ?>border-radius: <?php echo esc_attr($get_border_radius_cart_icon);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_cart_icon_color)) {
                                    ?>color: <?php echo esc_attr($get_cart_icon_color);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_padding_cart_icon)) {
                                    ?>padding: <?php echo esc_attr($get_padding_cart_icon);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            .navbar-area .navbar-area-2 .cart-btn i:hover {
                                <?php if ( !empty($get_cart_icon_bg_hover)) {
                                    ?>background: <?php echo esc_attr($get_cart_icon_bg_hover);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_border_color_cart_icon_hover)) {
                                    ?>border: 1px solid <?php echo esc_attr($get_border_color_cart_icon_hover);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_cart_icon_color_hover)) {
                                    ?>color: <?php echo esc_attr($get_cart_icon_color_hover);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }

                            span.cart-contents-count {
                                <?php if ( !empty($get_cart_counter_bg)) {
                                    ?>background: <?php echo esc_attr($get_cart_counter_bg);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_cart_counter_top)) {
                                    ?>top: <?php echo esc_attr($get_cart_counter_top);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_cart_counter_right)) {
                                    ?>right: <?php echo esc_attr($get_cart_counter_right);
                                    ?> !important;
                                    <?php
                                }

                                ?><?php if ( !empty($get_cart_counter_color)) {
                                    ?>color: <?php echo esc_attr($get_cart_counter_color);
                                    ?> !important;
                                    <?php
                                }

                                ?>
                            }
                            </style>
                            <?php
                                    if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                                        ?>
                            <div class="cart-btn">
                                <?php
                                                    // get_header(); 
                                                    echo do_shortcode("[woo_cart_but]");
                                                ?>
                            </div>
                            <?php
                                        } else {
                                    }
                                }
                                
                                ?>
                        </div>
                    </nav>
                </div>
                <?php
    }
    ?>
            </div>
            <div id="content" class="site-content">
                <?php do_action('hostiko_before_main_content'); ?>