<?php 
/** 
 * hostiko Customizer
 */
class hostiko_customizer {

	public $customizeObj;
	public $data;
	public $panelId;
	public function __construct($data) {
		$this->data = $data;
		add_action('customize_register',array($this,'hostiko_customize_register'));
		add_action('admin_enqueue_scripts', array($this,'custom_admin_style'));
		add_action( 'customize_save_after', array( $this,'update_akd_favicon_option' ) );
		add_action( 'customize_save_after', array( $this,'update_theme_option_from_customizer' ) );
	}
	
	function custom_admin_style($hook) {
		if ( 'customize.php' == $hook || 'widgets.php' == $hook ) {
			wp_enqueue_style( 'hostiko-customizer-style', get_template_directory_uri() . '/inc/css/hostiko-customizer-style.css',array());
			wp_enqueue_script( 'hostiko-customizer', get_template_directory_uri() . '/inc/js/hostiko-customizer.js', array( 'jquery' ), '20150611', true );
		}
	}	
	public function hostiko_customize_register($customizeObj) {
		
		$this->customizeObj = $customizeObj;
		$this->create_panal();
		$this->create_section();
	}
	
	public function create_panal() {
		if(is_array($this->data) && !empty($this->data)){
			$this->panelId = $this->data['panel']['id'];
			$args = array(
				'priority'       => $this->data['panel']['priority'],
				'capability'     => 'edit_theme_options',
				'theme_supports' => '',
				'title'          =>$this->data['panel']['name'] 
			);
			$this->customizeObj->add_panel($this->panelId,$args);
		}
	}
	
	public function create_section() {
		if(isset($this->data['panel']['section']) && !empty($this->data['panel']['section'])){
			$section = $this->data['panel']['section'];
			foreach($section as $key => $value){
				$args = array(
					'title'      => $value['name'],
					'priority'   => (isset($value['priority']))?$value['priority']:10,
					'panel'   => $this->panelId,
				);
				$this->customizeObj->add_section( $key , $args );
				if(!empty($value['fields'])){
					$this->create_field($value['fields'],$key);
				}
			}
		}
	}
	
	public function create_field($field,$id) {
		if(is_array($field)){
			foreach($field as $key =>$item){
				$this->create_setting($item);
				$this->create_control($item,$id);
			}
		}
		
	}
	
	public function create_setting($args) {
		$ar = array(
			'default'     => (isset($args['default']))?$args['default']:'',
			'transport'   => (isset($args['transport']))?$args['transport']:'postMessage'
		);
		if( isset($args['type']) AND $args['type']=='switch'){
			$ar['sanitize_callback'] = array($this,'sanitize_integer');
		}
		$this->customizeObj->add_setting( $args['id'],$ar);
		
	}
	
	public function create_control($value,$key) {
		$id = $value['id'];
		$args = array(
			'label'          => $value['name'],
			'section'        => $key,
			'settings'       => $id,
		);
		$inst = '';

		if ( isset($value['type']) ) {

			switch($value['type']){
				case "checkbox":
				case "select":
				case "radio":
				case "button":
					
					if(isset($value['choices'])){
						$args['type'] = $value['type'];
						$args['choices'] = (is_array($value['choices']))?$value['choices']:array('Select Option');
						$inst = new WP_Customize_Control($this->customizeObj,$id,$args);
					}
					break;
				case "switch":
					$args['type'] = $value['type'];
					$inst = new Hostiko_Customize_Switch_Control($this->customizeObj,$id,$args);
					break;
				case "image":
					$inst = new WP_Customize_Image_Control($this->customizeObj,$id,$args);
					break;
				default:
					$args['type'] = $value['type'];
					$inst = new WP_Customize_Control($this->customizeObj,$id,$args);
			}

		}
		else {

			$inst = new WP_Customize_Color_Control($this->customizeObj,$id,$args);
		}
		
		$this->customizeObj->add_control($inst);
	}
	
	public function sanitize_integer($input) {
		return intval( $input );
	}

	public static function hostiko_data_load() {

		$data = apply_filters( 'hostiko_customizer_data', array());
		if(!empty($data) && is_array($data)) {
			new self($data);
		}

	}

	public function update_akd_favicon_option( $wp_customize ) {
		// Get the new favicon ID from the site_icon setting
		$favicon_id = $wp_customize->get_setting( 'site_icon' )->value();
	
		// Retrieve the existing options array
		$akd_options = get_option( 'akd-framework-admin-page' );
	
		// Check if the options array exists and the favicon ID is valid
		if ( $akd_options && $favicon_id ) {
			// Get the URL of the favicon using the media ID
			$favicon_url = wp_get_attachment_url( $favicon_id );
	
			// Update the 'akd_update_favicon' key with the URL
			$akd_options['akd_update_favicon'] = $favicon_url;
	
			// Save the updated options back to the database
			update_option( 'akd-framework-admin-page', $akd_options );
		}
	}

	public function update_theme_option_from_customizer($wp_customize) {
		$theme = wp_get_theme();
		$theme_slug = $theme->get_stylesheet();
		$akd_theme_mods = get_option( 'theme_mods_' . $theme_slug );
		$akd_theme_admin_page = get_option( 'akd-framework-admin-page' );

		//Define the fields to check for update
		$fields = [
			'opt-switcher-topbar' => 'hostiko_topbar_switch',
			'opt-switcher-showbutton' => 'hostiko_show_header_btn',
			'login-button-txt' => 'hostiko_header_btn_text',
			'opt-switcher-topbar-bg' => 'hostiko_header_topbar_bg',
			
			'opt-switcher-livechat' => 'hostiko_show_live_chat_btn',
			'opt-livechat-bg' => 'hostiko_live_bg',
			'opt-livechat-color' => 'hostiko_live_color',
			'opt-livechat-border-color' => 'hostiko_live_border',
			'opt-livechat-border-radius' => 'hostiko_live_chat_br',
			'opt-livechat-padding' => 'hostiko_live_chat_padding',
			'opt-livechat-border-hover-color' => 'hostiko_live_border_hover',
			'opt-livechat-bg-hover-color' => 'hostiko_live_bg_hover',
			'opt-livechat-hover-color' => 'hostiko_live_color_hover',
		
			'opt-switcher-carticon' => 'hostiko_show_cart_icon_btn',
			'opt-carticon-bg' => 'hostiko_cart_icon_bg',
			'opt-carticon-color' => 'hostiko_cart_icon_color',
			'opt-carticon-border-color' => 'hostiko_cart_icon_border',
			'opt-carticon-border-radius' => 'hostiko_cart_icon_br',
			'opt-carticon-padding' => 'hostiko_cart_icon_padding',
			'opt-carticon-border-hover-color' => 'hostiko_cart_icon_border_hover',
			'opt-carticon-bg-hover-color' => 'hostiko_cart_icon_bg_hover',
			'opt-carticon-hover-color' => 'hostiko_cart_icon_color_hover',
			'opt-cartcounter-bg-color' => 'hostiko_cart_counter_bg',
			'opt-cartcounter-color' => 'hostiko_cart_counter_color',
			'opt-cartcounter-top' => 'hostiko_cart_counter_top',
			'opt-cartcounter-right' => 'hostiko_cart_counter_right',
		
			'opt-navbar-color' => 'hostiko_nav_color',
			'opt-navbar-hover-color' => 'hostiko_nav_hover_color',
			'opt-navbar-active-color' => 'hostiko_nav_active_color',
			'opt-navbar-dropdown-bg' => 'hostiko_nav_dropdown_bg',
			'opt-navbar-dropdown-hover-bg' => 'hostiko_nav_dropdown_bg_hover',
			'opt-navbar-dropdown-color' => 'hostiko_nav_dropdown_color',
			'opt-navbar-dropdown-hover-color' => 'hostiko_nav_dropdown_hover_color',
			'opt-navbar-dropdown-position' => 'hostiko_navbar_dropdown_position',
			'opt-navbar-dropdown-border-radius' => 'hostiko_navbar_dropdown_br',
			'opt-navbar-dropdown-border-width' => 'hostiko_dropdown_border_width',
			'opt-navbar-dropdown-border-color' => 'hostiko_nav_dropdown_border_color',
			'opt-navbar-dropdown-bg-color-mobile' => 'hostiko_nav_dropdown_bg_mobile',
			'opt-navbar-dropdown-color-mobile' => 'hostiko_nav_dropdown_color_mobile',
			'opt-navbar-dropdown-color-hover-mobile' => 'hostiko_nav_dropdown_color_hover_mobile',
			'opt-navbar-hamburger-color' => 'hostiko_nav_hamburger_color',
			'opt-navbar-dropdown-border-bottom-width' => 'hostiko_nav_border_bottom',
			
			'login-btn-link' => 'hostiko_header_btn_link',
			'opt-switcher-stikyheader' => 'hostiko_sticky_header_btn',
			'opt-switcher-stikyheader-bg' => 'hostiko_stickyheader_bg',
			'opt-select-header-elementor-template' => 'choose_elementor_header',
			'opt-select-footer-elementor-template' => 'choose_elementor_footer',
			'opt-select-footer-style' => 'choose_default_footer',
			'copyright-txt' => 'hostiko_copyright',
			'opt-switcher-subbanner' => 'hostiko_sub_banner_show',
			'opt-switcher-breadcrumb' => 'hostiko_breadcrumb_show',
			'opt-breadcrumb-title-color' => 'page_title_color',
			'opt-subtitle-color' => 'page_subtitle_color',
			'opt-breadcrumb-bg-color' => 'breadcrumb_bg_color',
			'opt-breadcrumb-color' => 'hostiko_breadcrumb_color',
			'opt-breadcrumb-current-page-color' => 'hostiko_breadcrumb_current_page_color',
			'opt-breadcrumb-hover-color' => 'hostiko_breadcrumb_hover_color',
			'opt-breadcrumb-active-color' => 'hostiko_breadcrumb_active_color',
			'opt-breadcrumb-border-radius' => 'hostiko_breadcrumb_br',
			'opt-breadcrumb-border-width' => 'hostiko_breadcrumb_border_width',
			'opt-breadcrumb-border-color' => 'hostiko_breadcrumb_border_color',
			'opt-breadcrumb-padding' => 'hostiko_breadcrumb_padding',
			'opt-subBannerImage' => 'sub-banner-img',
			'opt-subbanner-padding-desktop' => 'hostiko_sub_banner_padding_desk',
			'opt-subbanner-padding-laptop' => 'hostiko_sub_banner_padding_lap',
			'opt-subbanner-padding-tablet' => 'hostiko_sub_banner_padding_tab',
			'opt-subbanner-padding-mobile' => 'hostiko_sub_banner_padding_mobile',
			'opt-blog-page-title' => 'breadcrumb_blog_title',
			'opt-blog-page-subTitle' => 'breadcrumb_blog_title_details',
			'opt-404-title' => 'hostiko_error_404_text',
			'opt-404-not-found-title' => 'hostiko_error_title',
			'opt-404-desc' => 'hostiko_error_desc',
			'opt-404-link-text' => 'hostiko_error_link_text',
			'opt-switcher-preloader' => 'hostiko_preloader_switch',
			'opt-switcher-showinvestment' => 'hostiko_show_investment_offer_link',
			'investment-button-txt' => 'hostiko_header_link_text',
			'investment-btn-link' => 'hostiko_header_link_url',
			'opt-switcher-show-contact-info' => 'hostiko_show_contact_info',
			'email-txt' => 'hostiko_header_email',
			'phone-txt' => 'hostiko_header_phone',
			'opt-switcher-customizer-settings' => 'hostiko_enable_customizer_settings',
			'opt-switcher-socialprofiles' => 'hostiko_show_social_profiles',
			'social-fb-link' => 'hostiko_topbar_fb_url',
			'social-x-link' => 'hostiko_topbar_twitter_url',
			'social-linkedin-link' => 'hostiko_topbar_linkedin_url',
			'social-instagram-link' => 'hostiko_topbar_instagram_url',

			
		];


		$updated = false;

		foreach ($fields as $post_key => $theme_mod_key) {
			if (isset($akd_theme_mods[$theme_mod_key])) {
				
				$new_value = $akd_theme_mods[$theme_mod_key];
				
				
				if (!isset($akd_theme_admin_page[$post_key]) || $akd_theme_admin_page[$post_key] !== $new_value) {
					if(
						$post_key == 'login-btn-link' ||
						$post_key == 'investment-btn-link' ||
						$post_key == 'social-fb-link' ||
						$post_key == 'social-x-link' ||
						$post_key == 'social-linkedin-link' ||
						$post_key == 'social-instagram-link'
					)
					{
						$akd_theme_admin_page[$post_key]['url'] = $new_value;
					}
					$akd_theme_admin_page[$post_key] = $new_value;
					$updated = true;
				}
			}
		}

		// Update theme mods only if changes exist
		if ($updated) {
			update_option( 'akd-framework-admin-page' , $akd_theme_admin_page );
		}

		// Update the opt-switcher-topbar setting in the array
		// $akd_theme_admin_page['opt-switcher-topbar'] = isset($akd_theme_mods['hostiko_topbar_switch']) ? $akd_theme_mods['hostiko_topbar_switch'] : '';
		// $akd_theme_admin_page['opt-switcher-topbar-bg'] = isset($akd_theme_mods['hostiko_header_topbar_bg']) ? $akd_theme_mods['hostiko_header_topbar_bg'] : '';
		
		// $akd_theme_admin_page['opt-switcher-livechat'] = isset($akd_theme_mods['hostiko_show_live_chat_btn']) ? $akd_theme_mods['hostiko_show_live_chat_btn'] : '';
		// $akd_theme_admin_page['opt-livechat-bg'] = isset($akd_theme_mods['hostiko_live_bg']) ? $akd_theme_mods['hostiko_live_bg'] : '';
		// $akd_theme_admin_page['opt-livechat-color'] = isset($akd_theme_mods['hostiko_live_color']) ? $akd_theme_mods['hostiko_live_color'] : '';
		// $akd_theme_admin_page['opt-livechat-border-color'] = isset($akd_theme_mods['hostiko_live_border']) ? $akd_theme_mods['hostiko_live_border'] : '';
		// $akd_theme_admin_page['opt-livechat-border-radius'] = isset($akd_theme_mods['hostiko_live_chat_br']) ? $akd_theme_mods['hostiko_live_chat_br'] : '';
		// $akd_theme_admin_page['opt-livechat-padding'] = isset($akd_theme_mods['hostiko_live_chat_padding']) ? $akd_theme_mods['hostiko_live_chat_padding'] : '';
		// $akd_theme_admin_page['opt-livechat-border-hover-color'] = isset($akd_theme_mods['hostiko_live_border_hover']) ? $akd_theme_mods['hostiko_live_border_hover'] : '';
		// $akd_theme_admin_page['opt-livechat-bg-hover-color'] = isset($akd_theme_mods['hostiko_live_bg_hover']) ? $akd_theme_mods['hostiko_live_bg_hover'] : '';
		// $akd_theme_admin_page['opt-livechat-hover-color'] = isset($akd_theme_mods['hostiko_live_color_hover']) ? $akd_theme_mods['hostiko_live_color_hover'] : '';
		
		// $akd_theme_admin_page['opt-switcher-carticon'] = isset($akd_theme_mods['hostiko_show_cart_icon_btn']) ? $akd_theme_mods['hostiko_show_cart_icon_btn'] : '';
		// $akd_theme_admin_page['opt-carticon-bg'] = isset($akd_theme_mods['hostiko_cart_icon_bg']) ? $akd_theme_mods['hostiko_cart_icon_bg'] : '';
		// $akd_theme_admin_page['opt-carticon-color'] = isset($akd_theme_mods['hostiko_cart_icon_color']) ? $akd_theme_mods['hostiko_cart_icon_color'] : '';
		// $akd_theme_admin_page['opt-carticon-border-color'] = isset($akd_theme_mods['hostiko_cart_icon_border']) ? $akd_theme_mods['hostiko_cart_icon_border'] : '';
		// $akd_theme_admin_page['opt-carticon-border-radius'] = isset($akd_theme_mods['hostiko_cart_icon_br']) ? $akd_theme_mods['hostiko_cart_icon_br'] : '';
		// $akd_theme_admin_page['opt-carticon-padding'] = isset($akd_theme_mods['hostiko_cart_icon_padding']) ? $akd_theme_mods['hostiko_cart_icon_padding'] : '';
		// $akd_theme_admin_page['opt-carticon-border-hover-color'] = isset($akd_theme_mods['hostiko_cart_icon_border_hover']) ? $akd_theme_mods['hostiko_cart_icon_border_hover'] : '';
		// $akd_theme_admin_page['opt-carticon-bg-hover-color'] = isset($akd_theme_mods['hostiko_cart_icon_bg_hover']) ? $akd_theme_mods['hostiko_cart_icon_bg_hover'] : '';
		// $akd_theme_admin_page['opt-carticon-hover-color'] = isset($akd_theme_mods['hostiko_cart_icon_color_hover']) ? $akd_theme_mods['hostiko_cart_icon_color_hover'] : '';
		// $akd_theme_admin_page['opt-cartcounter-bg-color'] = isset($akd_theme_mods['hostiko_cart_counter_bg']) ? $akd_theme_mods['hostiko_cart_counter_bg'] : '';
		// $akd_theme_admin_page['opt-cartcounter-color'] = isset($akd_theme_mods['hostiko_cart_counter_color']) ? $akd_theme_mods['hostiko_cart_counter_color'] : '';
		// $akd_theme_admin_page['opt-cartcounter-top'] = isset($akd_theme_mods['hostiko_cart_counter_top']) ? $akd_theme_mods['hostiko_cart_counter_top'] : '';
		// $akd_theme_admin_page['opt-cartcounter-right'] = isset($akd_theme_mods['hostiko_cart_counter_right']) ? $akd_theme_mods['hostiko_cart_counter_right'] : '';
		
		// $akd_theme_admin_page['opt-navbar-color'] = isset($akd_theme_mods['hostiko_nav_color']) ? $akd_theme_mods['hostiko_nav_color'] : '';
		// $akd_theme_admin_page['opt-navbar-hover-color'] = isset($akd_theme_mods['hostiko_nav_hover_color']) ? $akd_theme_mods['hostiko_nav_hover_color'] : '';
		// $akd_theme_admin_page['opt-navbar-active-color'] = isset($akd_theme_mods['hostiko_nav_active_color']) ? $akd_theme_mods['hostiko_nav_active_color'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-bg'] = isset($akd_theme_mods['hostiko_nav_dropdown_bg']) ? $akd_theme_mods['hostiko_nav_dropdown_bg'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-hover-bg'] = isset($akd_theme_mods['hostiko_nav_dropdown_bg_hover']) ? $akd_theme_mods['hostiko_nav_dropdown_bg_hover'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-color'] = isset($akd_theme_mods['hostiko_nav_dropdown_color']) ? $akd_theme_mods['hostiko_nav_dropdown_color'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-hover-color'] = isset($akd_theme_mods['hostiko_nav_dropdown_hover_color']) ? $akd_theme_mods['hostiko_nav_dropdown_hover_color'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-position'] = isset($akd_theme_mods['hostiko_navbar_dropdown_position']) ? $akd_theme_mods['hostiko_navbar_dropdown_position'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-border-radius'] = isset($akd_theme_mods['hostiko_navbar_dropdown_br']) ? $akd_theme_mods['hostiko_navbar_dropdown_br'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-border-width'] = isset($akd_theme_mods['hostiko_dropdown_border_width']) ? $akd_theme_mods['hostiko_dropdown_border_width'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-border-color'] = isset($akd_theme_mods['hostiko_nav_dropdown_border_color']) ? $akd_theme_mods['hostiko_nav_dropdown_border_color'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-bg-color-mobile'] = isset($akd_theme_mods['hostiko_nav_dropdown_bg_mobile']) ? $akd_theme_mods['hostiko_nav_dropdown_bg_mobile'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-color-mobile'] = isset($akd_theme_mods['hostiko_nav_dropdown_color_mobile']) ? $akd_theme_mods['hostiko_nav_dropdown_color_mobile'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-color-hover-mobile'] = isset($akd_theme_mods['hostiko_nav_dropdown_color_hover_mobile']) ? $akd_theme_mods['hostiko_nav_dropdown_color_hover_mobile'] : '';
		// $akd_theme_admin_page['opt-navbar-hamburger-color'] = isset($akd_theme_mods['hostiko_nav_hamburger_color']) ? $akd_theme_mods['hostiko_nav_hamburger_color'] : '';
		// $akd_theme_admin_page['opt-navbar-dropdown-border-bottom-width'] = isset($akd_theme_mods['hostiko_nav_border_bottom']) ? $akd_theme_mods['hostiko_nav_border_bottom'] : '';
		// $akd_theme_admin_page['opt-navbar-border-bottom-color'] = isset($akd_theme_mods['hostiko_nav_border_bottom_color']) ? $akd_theme_mods['hostiko_nav_border_bottom_color'] : '';
		
		
		// $akd_theme_admin_page['opt-switcher-showbutton'] = isset($akd_theme_mods['hostiko_show_header_btn']) ? $akd_theme_mods['hostiko_show_header_btn'] : '';
		// $akd_theme_admin_page['login-button-txt'] = isset($akd_theme_mods['hostiko_header_btn_text']) ? $akd_theme_mods['hostiko_header_btn_text'] : '';
		// $akd_theme_admin_page['login-btn-link']['url'] = isset($akd_theme_mods['hostiko_header_btn_link']) ? $akd_theme_mods['hostiko_header_btn_link'] : '';
		
		// $akd_theme_admin_page['opt-switcher-investment-link'] = isset($akd_theme_mods['hostiko_show_investment_offer_link']) ? $akd_theme_mods['hostiko_show_investment_offer_link'] : '';
		// $akd_theme_admin_page['investment-button-txt'] = isset($akd_theme_mods['hostiko_header_link_text']) ? $akd_theme_mods['hostiko_header_link_text'] : '';
		// $akd_theme_admin_page['investment-btn-link']['url'] = isset($akd_theme_mods['hostiko_header_link_url']) ? $akd_theme_mods['hostiko_header_link_url'] : '';
		
		// $akd_theme_admin_page['opt-switcher-contact-info'] = isset($akd_theme_mods['hostiko_show_contact_info']) ? $akd_theme_mods['hostiko_show_contact_info'] : '';
		// $akd_theme_admin_page['contact-info-email'] = isset($akd_theme_mods['hostiko_header_email']) ? $akd_theme_mods['hostiko_header_email'] : '';
		// $akd_theme_admin_page['contact-info-phone'] = isset($akd_theme_mods['hostiko_header_phone']) ? $akd_theme_mods['hostiko_header_phone'] : '';
		
		
		// $akd_theme_admin_page['opt-switcher-stikyheader'] = isset($akd_theme_mods['hostiko_sticky_header_btn']) ? $akd_theme_mods['hostiko_sticky_header_btn'] : '';
		// $akd_theme_admin_page['opt-select-header-elementor-template'] = isset($akd_theme_mods['choose_elementor_header']) ? $akd_theme_mods['choose_elementor_header'] : '';
		// $akd_theme_admin_page['opt-select-footer-elementor-template'] = isset($akd_theme_mods['choose_elementor_footer']) ? $akd_theme_mods['choose_elementor_footer'] : '';
		// $akd_theme_admin_page['opt-select-footer-style'] = isset($akd_theme_mods['choose_default_footer']) ? $akd_theme_mods['choose_default_footer'] : '';
		// $akd_theme_admin_page['copyright-txt'] = isset($akd_theme_mods['hostiko_copyright']) ? $akd_theme_mods['hostiko_copyright'] : '';
		// $akd_theme_admin_page['opt-switcher-subbanner'] = isset($akd_theme_mods['hostiko_sub_banner_show']) ? $akd_theme_mods['hostiko_sub_banner_show'] : '';
		// $akd_theme_admin_page['opt-switcher-breadcrumb'] = isset($akd_theme_mods['hostiko_breadcrumb_show']) ? $akd_theme_mods['hostiko_breadcrumb_show'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-title-color'] = isset($akd_theme_mods['page_title_color']) ? $akd_theme_mods['page_title_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-bg-color'] = isset($akd_theme_mods['breadcrumb_bg_color']) ? $akd_theme_mods['breadcrumb_bg_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-color'] = isset($akd_theme_mods['hostiko_breadcrumb_color']) ? $akd_theme_mods['hostiko_breadcrumb_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-current-page-color'] = isset($akd_theme_mods['hostiko_breadcrumb_current_page_color']) ? $akd_theme_mods['hostiko_breadcrumb_current_page_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-hover-color'] = isset($akd_theme_mods['hostiko_breadcrumb_hover_color']) ? $akd_theme_mods['hostiko_breadcrumb_hover_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-active-color'] = isset($akd_theme_mods['hostiko_breadcrumb_active_color']) ? $akd_theme_mods['hostiko_breadcrumb_active_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-border-radius'] = isset($akd_theme_mods['hostiko_breadcrumb_br']) ? $akd_theme_mods['hostiko_breadcrumb_br'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-border-width'] = isset($akd_theme_mods['hostiko_breadcrumb_border_width']) ? $akd_theme_mods['hostiko_breadcrumb_border_width'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-border-color'] = isset($akd_theme_mods['hostiko_breadcrumb_border_color']) ? $akd_theme_mods['hostiko_breadcrumb_border_color'] : '';
		// $akd_theme_admin_page['opt-breadcrumb-padding'] = isset($akd_theme_mods['hostiko_breadcrumb_padding']) ? $akd_theme_mods['hostiko_breadcrumb_padding'] : '';
		
		
		// $akd_theme_admin_page['opt-subBannerImage'] = isset($akd_theme_mods['sub-banner-img']) ? $akd_theme_mods['sub-banner-img'] : '';
		// $akd_theme_admin_page['opt-blog-page-title'] = isset($akd_theme_mods['breadcrumb_blog_title']) ? $akd_theme_mods['breadcrumb_blog_title'] : '';
		// $akd_theme_admin_page['opt-blog-page-subTitle'] = isset($akd_theme_mods['breadcrumb_blog_title_details']) ? $akd_theme_mods['breadcrumb_blog_title_details'] : '';
		// $akd_theme_admin_page['opt-404-title'] = isset($akd_theme_mods['hostiko_error_404_text']) ? $akd_theme_mods['hostiko_error_404_text'] : '';
		// $akd_theme_admin_page['opt-404-not-found-title'] = isset($akd_theme_mods['hostiko_error_title']) ? $akd_theme_mods['hostiko_error_title'] : '';
		// $akd_theme_admin_page['opt-404-desc'] = isset($akd_theme_mods['hostiko_error_desc']) ? $akd_theme_mods['hostiko_error_desc'] : '';
		// $akd_theme_admin_page['opt-404-link-text'] = isset($akd_theme_mods['hostiko_error_link_text']) ? $akd_theme_mods['hostiko_error_link_text'] : '';
		// $akd_theme_admin_page['opt-switcher-preloader'] = isset($akd_theme_mods['hostiko_preloader_switch']) ? $akd_theme_mods['hostiko_preloader_switch'] : '';
		// $akd_theme_admin_page['opt-switcher-preloader'] = isset($akd_theme_mods['show_preloader']) ? $akd_theme_mods['show_preloader'] : '';
		
		// $akd_theme_admin_page['opt-switcher-showinvestment'] = isset($akd_theme_mods['hostiko_show_investment_offer_link']) ? $akd_theme_mods['hostiko_show_investment_offer_link'] : '';
		// $akd_theme_admin_page['investment-button-txt'] = isset($akd_theme_mods['hostiko_header_link_text']) ? $akd_theme_mods['hostiko_header_link_text'] : '';
		// $akd_theme_admin_page['investment-btn-link']['url'] = isset($akd_theme_mods['hostiko_header_link_url']) ? $akd_theme_mods['hostiko_header_link_url'] : '';
		
		// $akd_theme_admin_page['opt-switcher-show-contact-info'] = isset($akd_theme_mods['hostiko_show_contact_info']) ? $akd_theme_mods['hostiko_show_contact_info'] : '';
		// $akd_theme_admin_page['email-txt'] = isset($akd_theme_mods['hostiko_header_email']) ? $akd_theme_mods['hostiko_header_email'] : '';
		// $akd_theme_admin_page['phone-txt'] = isset($akd_theme_mods['hostiko_header_phone']) ? $akd_theme_mods['hostiko_header_phone'] : '';
		
		// $akd_theme_admin_page['opt-switcher-customizer-settings'] = isset($akd_theme_mods['hostiko_enable_customizer_settings']) ? $akd_theme_mods['hostiko_enable_customizer_settings'] : '';
		
		// $akd_theme_mods['hostiko_preloader_switch'] = isset($akd_theme_mods['show_preloader']) ? $akd_theme_mods['show_preloader'] : '';
		// $akd_theme_mods['show_preloader'] = isset($akd_theme_mods['hostiko_preloader_switch']) ? $akd_theme_mods['hostiko_preloader_switch'] : '';
		
		// $akd_theme_mods['opt-switcher-socialprofiles'] = isset($akd_theme_mods['hostiko_show_social_profiles']) ? $akd_theme_mods['hostiko_show_social_profiles'] : '';
		// $akd_theme_admin_page['social-fb-link']['url'] = isset($akd_theme_mods['hostiko_topbar_fb_url']) ? $akd_theme_mods['hostiko_topbar_fb_url'] : '';
		// $akd_theme_admin_page['social-x-link']['url'] = isset($akd_theme_mods['hostiko_topbar_twitter_url']) ? $akd_theme_mods['hostiko_topbar_twitter_url'] : '';
		// $akd_theme_admin_page['social-linkedin-link']['url'] = isset($akd_theme_mods['hostiko_topbar_linkedin_url']) ? $akd_theme_mods['hostiko_topbar_linkedin_url'] : '';
		// $akd_theme_admin_page['social-instagram-link']['url'] = isset($akd_theme_mods['hostiko_topbar_instagram_url']) ? $akd_theme_mods['hostiko_topbar_instagram_url'] : '';
		

		// update_option( 'akd-framework-admin-page' , $akd_theme_admin_page );
	}
	
}
add_action('init','hostiko_customizer::hostiko_data_load');

/** 
 * Customizer
 */
if(class_exists( 'WP_Customize_control')) {
	
	class Hostiko_Customize_Switch_Control extends WP_Customize_Control {
		public $type = 'switch';
		public function render_content() {
			?>
<label>
    <span class="customize-control-title"><?php print esc_html( $this->label ); ?></span>
    <span class="description customize-control-description"><?php print esc_html( $this->description ); ?></span>
    <div class="switch_options">
        <span class="switch_enable"><?php esc_html_e('Yes','hostiko'); ?></span>
        <span class="switch_disable"><?php esc_html_e('No','hostiko'); ?></span>
        <input type="hidden" id="switch_yes_no" <?php $this->link(); ?>
            value="<?php print esc_html($this->value()); ?>" />
    </div>
</label>
<?php
		}
	}
}