<?php
/**
 * Custom template tags for this theme
 * Eventually, some of the functionality here could be replaced by core features.
 * @package hostiko
*/

//hostiko_header_social_profiles
function hostiko_header_social_profiles() {
    $hostiko_topbar_fb_url             = get_theme_mod('hostiko_topbar_fb_url', '#');
    $hostiko_topbar_twitter_url       = get_theme_mod('hostiko_topbar_twitter_url', '#');
    $hostiko_topbar_linkedin_url      = get_theme_mod('hostiko_topbar_linkedin_url', '#');
    $hostiko_topbar_instagram_url        = get_theme_mod('hostiko_topbar_instagram_url', '#');
    $enable_header_social_profile        = get_theme_mod('hostiko_show_social_profiles');
    if( $enable_header_social_profile  == true ):
        if ($hostiko_topbar_fb_url != '#'): ?>
<li class="topbar-single-info topbar-social-icon">
    <a href="<?php print esc_url($hostiko_topbar_fb_url); ?>"><i class="fab fa-facebook"></i></a>
</li>
<?php endif; 
        if ($hostiko_topbar_twitter_url != '#'): ?>
<li class="topbar-single-info topbar-social-icon">
    <a href="<?php print esc_url($hostiko_topbar_twitter_url); ?>"><i class="fab fa-twitter"></i></a>
</li>
<?php 
        endif; 
        if ($hostiko_topbar_linkedin_url != '#'): ?>
<li class="topbar-single-info topbar-social-icon">
    <a href="<?php print esc_url($hostiko_topbar_instagram_url); ?>"><i class="fab fa-linkedin"></i></a>
</li>
<?php 
        endif; 
        if ($hostiko_topbar_instagram_url != '#'): ?>
<li class="topbar-single-info topbar-social-icon">
    <a href="<?php print esc_url($hostiko_topbar_instagram_url); ?>"><i class="fab fa-instagram"></i></a>
</li>
<?php 
        endif; 
    endif;
}


//investion login
function hostiko_user_login(){
    $hostiko_header_topbar_bg = get_theme_mod('hostiko_header_topbar_bg');
                 
        ?>
<style>
.navbar-area-2 .navbar-top {
    <?php if ( !empty($hostiko_header_topbar_bg)) {
        ?>background: <?php echo esc_attr($hostiko_header_topbar_bg);
        ?> !important;
        <?php
    }

    ?>
}
</style>
<?php
     // header button
    $enable_hostiko_show_investment_offer_link = get_theme_mod('hostiko_show_investment_offer_link');

    $enable_header_btn = get_theme_mod('hostiko_show_header_btn');
    $enable_header_btn_text = get_theme_mod('hostiko_header_btn_text', esc_html__('Sign in', 'hostiko'));
    $enable_header_btn_icon = get_theme_mod('hostiko_header_btn_icon', esc_html__('fa fa-user-o', 'hostiko'));  
    $enale_hostiko_header_btn_link = get_theme_mod('hostiko_header_btn_link');  
    if( $enable_header_btn == true ){?>
<li class="topbar-single-info topbar-signin sign-nav ml-3 ml-lg-0">
    <a href="<?php echo $enale_hostiko_header_btn_link; ?>"><i
            class="<?php echo esc_attr( $enable_header_btn_icon ); ?>"></i>
        <?php echo esc_html( $enable_header_btn_text ); ?></a>
</li>
<?php 
    }

    // if($enable_header_btn && $enable_header_btn == 1 && $enable_hostiko_show_investment_offer_link && $enable_hostiko_show_investment_offer_link == 1){
        ?>
<!-- <style>
            .navbar-top .topbar-right li:last-child:before {
                position: absolute;
                content: "";
                background-color: var(--e-global-color-white);
                width: 1px;
                height: 16px;
                top: 22px;
                left: -8px;
            }
        </style> -->
<?php
    // }
}


// hostiko header logo
function hostiko_header_logo() {
    ?>
<?php 
    $hostiko_logo_on = get_post_meta(get_the_ID(), 'hostiko_enable_sec_logo', true);
    $hostiko_logo = get_template_directory_uri() . '/assets/img/logo/logo.png';
    $hostiko_logo_white = get_template_directory_uri() . '/assets/img/logo/logo-white.png';
    $hostiko_retina_logo = get_template_directory_uri().'/assets/img/logo/logo@2x.png';
    $hostiko_retina_logo_white = get_template_directory_uri().'/assets/img/logo/logo-white@2x.png';
    $hostiko_retina_logo  = get_theme_mod('retina_logo',$hostiko_retina_logo);
    // $hostiko_retina_logo_white  = get_theme_mod('retina_secondary_logo',$hostiko_retina_logo_white);
    $hostiko_site_logo = get_theme_mod('logo', $hostiko_logo);
    $hostiko_secondary_logo = get_theme_mod('seconday_logo', $hostiko_logo_white);
    ?>
<?php
    if( has_custom_logo()){
        the_custom_logo();
    }else{
        if($hostiko_logo_on === 'on') { ?>
<a class="standard-logo" href="<?php print esc_url(home_url('/')); ?>">
    <img src="<?php print esc_url($hostiko_secondary_logo); ?>" alt="<?php print esc_attr('logo','hostiko'); ?>" />
</a>
<a class="retina-logo" href="<?php print esc_url(home_url('/')); ?>">
    <img src="<?php print esc_url($hostiko_retina_logo_white); ?>" alt="<?php print esc_attr('logo','hostiko'); ?>" />
</a>
<?php 
        }
        else{ ?>
<a class="standard-logo" href="<?php print esc_url(home_url('/')); ?>">
    <img src="<?php print esc_url($hostiko_site_logo); ?>" alt="<?php print esc_attr('logo','hostiko'); ?>" />
</a>
<a class="retina-logo" href="<?php print esc_url(home_url('/')); ?>">
    <img src="<?php print esc_url($hostiko_retina_logo); ?>" alt="<?php print esc_attr('logo','hostiko'); ?>" />
</a>
<?php 
        }
    }   
    ?>
<?php 
} 


//hostiko breadcrumb
add_action('hostiko_before_main_content', 'hostiko_check_breadcrumb');
function hostiko_check_breadcrumb() {
    $hostiko_breadcrumb_style = get_post_meta( get_the_ID(), 's7template_choice_breadcrumb_style', true );
    $hostiko_default_breadcrumb_style = get_theme_mod('choose_default_breadcrumb', 'breadcrumb-style-1' );
    if( $hostiko_breadcrumb_style == 'breadcrumb-style-1' ) {
        hostiko_breadcrumb_style_1();
    }
    elseif( $hostiko_breadcrumb_style == 'breadcrumb-style-2' ) {
        hostiko_breadcrumb_style_2();
    }
    else {
        if($hostiko_default_breadcrumb_style == 'breadcrumb-style-1'){
            hostiko_breadcrumb_style_1();
        }elseif($hostiko_default_breadcrumb_style == 'breadcrumb-style-2'){
            hostiko_breadcrumb_style_2();
        }
    }
}

//hostiko_breadcrumb_style_1
function hostiko_breadcrumb_style_1() { 
    $hostiko_invisible_breadcrumb = get_post_meta( get_the_ID(), 's7template_invisible_breadcrumb', true );
    if( !$hostiko_invisible_breadcrumb ) {
        $breadcrumb_img_from_page = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_img_from_page', true);
        $breadcrumb_color_from_page = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_color', true);
        $hide_breadcrumb_bg_img = get_post_meta(get_the_ID(), 's7template_hide_breadcrumb_bg_img', true); 
        $sub_banner_img= get_theme_mod('sub-banner-img');

        // Get the current post ID (works on single pages/posts)
        $post_id = get_the_ID();

        // Get the Elementor page setting for banner display
        $page_hide_banner = get_post_meta($post_id, '_elementor_page_settings', true);

        // Default to global setting
        $get_banner_show = get_theme_mod('hostiko_sub_banner_show', 1);
        $d_none = '';

        // If per-page setting exists and is set to 'yes', hide the banner
        if (!empty($page_hide_banner['banner_display']) && $page_hide_banner['banner_display'] === 'yes') {
            $d_none = 'd-none';
        }
        // Otherwise, check global setting
        elseif ($get_banner_show == '0') {
            $d_none = 'd-none';
        }
        
        $hostiko_sub_banner_padding_desk = get_theme_mod('hostiko_sub_banner_padding_desk');
        $hostiko_sub_banner_padding = get_theme_mod('hostiko_sub_banner_padding_lap');
        $hostiko_sub_banner_padding_tab = get_theme_mod('hostiko_sub_banner_padding_tab');
        $hostiko_sub_banner_padding_mobile = get_theme_mod('hostiko_sub_banner_padding_mobile');
        ?>
<style>
@media (min-width: 1200px) {
    .page-title-area {
        <?php if ( !empty($hostiko_sub_banner_padding_desk)) {
            ?>padding: <?php echo esc_attr($hostiko_sub_banner_padding_desk);
            ?> !important;
            <?php
        }

        ?>
    }
}

@media (max-width: 1199px) {
    .page-title-area {
        <?php if ( !empty($hostiko_sub_banner_padding)) {
            ?>padding: <?php echo esc_attr($hostiko_sub_banner_padding);
            ?> !important;
            <?php
        }

        ?>
    }
}

@media only screen and (max-width: 767px) {
    .page-title-area {
        <?php if ( !empty($hostiko_sub_banner_padding_tab)) {
            ?>padding: <?php echo esc_attr($hostiko_sub_banner_padding_tab);
            ?> !important;
            <?php
        }

        ?>
    }
}

@media only screen and (max-width: 575px) {
    .page-title-area {
        <?php if ( !empty($hostiko_sub_banner_padding_mobile)) {
            ?>padding: <?php echo esc_attr($hostiko_sub_banner_padding_mobile);
            ?> !important;
            <?php
        }

        ?>
    }
}
</style>
<?php
               
        if($sub_banner_img !== null && $sub_banner_img ==""){
            $sub_banner_img = get_template_directory_uri() . '/assets/img/sub-banner-img.jpg';
        }
       
        // breadcrumb bg image
        if( empty($hide_breadcrumb_bg_img ) ){

            if( $breadcrumb_img_from_page ){
                $bg_img = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_img_from_page', true);
                $bg_img = 'background-image :url('.$bg_img.')';   
            }else{
                $bg_img = get_theme_mod('breadcrumb_bg_img');
                $bg_img = 'background-image :url('.$bg_img.')';    
            }    
        }else{
            $bg_img = "";
        } 
        // breadcrumb color
        if( $breadcrumb_color_from_page ){
            $bg_color = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_color', true);
            $bg_color = 'background-color :'.$bg_color.'';    
        }else{
            $bg_color = get_theme_mod('breadcrumb_bg_color');
            $bg_color = 'background-color :'.$bg_color.'';    
        }
        $breadcrumb_blog_title = get_theme_mod('breadcrumb_blog_title', esc_html__('Blog ', 'hostiko'));
        $breadcrumb_blog_title_details = get_theme_mod('breadcrumb_blog_title_details', esc_html__('Read latest news from our blog & learn new things', 'hostiko'));
        $hostiko_blog_breadcrumb = get_theme_mod('hostiko_blog_breadcrumb', '');
        $hostiko_breadcrumb_show = get_theme_mod('hostiko_breadcrumb_show', 1);
        $hostiko_page_title = get_the_title(get_queried_object_id());
        $featured_img = get_the_post_thumbnail_url(get_the_ID(),'full');
        $getBannerSetting = get_post_meta(get_the_ID(),'_elementor_page_settings', true);
        ?>
<style>
.page-title-area h1,
.page-title-area .title,
.page-title-area.style-1 div.text-center {
    color: <?php echo (get_theme_mod('page_title_color'))?get_theme_mod('page_title_color').' !important':'#343a40';
    ?>;
}

.page-title-area p {
    color: <?php echo (get_theme_mod('page_subtitle_color'))?get_theme_mod('page_subtitle_color').' !important':'#343a40';
    ?>;
}

.page-title-area .breadcrumb {
    background-color: <?php echo (get_theme_mod('breadcrumb_bg_color'))?get_theme_mod('breadcrumb_bg_color').' !important':'';
    ?>;
    border-radius: <?php echo (get_theme_mod('hostiko_breadcrumb_br'))?get_theme_mod('hostiko_breadcrumb_br').' !important':'';
    ?>;
    padding: <?php echo (get_theme_mod('hostiko_breadcrumb_padding'))?get_theme_mod('hostiko_breadcrumb_padding').' !important':'';
    ?>;
    border: <?php echo (get_theme_mod('hostiko_breadcrumb_border_width')) ? get_theme_mod('hostiko_breadcrumb_border_width') . ' solid '. (get_theme_mod('hostiko_breadcrumb_border_color') ? get_theme_mod('hostiko_breadcrumb_border_color') : '#343a40') . ' !important;'
        : '';
    ?>;

}

.page-title-area .breadcrumb a {
    color: <?php echo (get_theme_mod('hostiko_breadcrumb_color'))?get_theme_mod('hostiko_breadcrumb_color').' !important':'#343a40';
    ?>;
}

.breadcrumb li:last-child a,
.breadcrumb li:not(:last-child)::after {
    color: <?php echo (get_theme_mod('hostiko_breadcrumb_current_page_color'))?get_theme_mod('hostiko_breadcrumb_current_page_color').' !important':'#343a40';
    ?>;
}

.breadcrumb li a:hover {
    color: <?php echo (get_theme_mod('hostiko_breadcrumb_hover_color'))?get_theme_mod('hostiko_breadcrumb_hover_color').' !important':'#343a40';
    ?>;
}
</style>
<?php

        if ( is_front_page() && is_home() ) { ?>

<!-- page-title area start -->
<div class="page-title-area overlay-bg style-1 <?php echo $d_none; ?>"
    style="<?php if ($featured_img) { ?> background-image: url(<?php the_post_thumbnail_url( 'full' ); }else if (!$featured_img) { ?> background-image: url(<?php echo $sub_banner_img; } else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-sm-12 text-center">
                <h1 class="title"><?php print esc_html($breadcrumb_blog_title); ?></h1>
                <?php
                                $meta = get_post_meta(get_the_ID(),'my-meta-box', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                }
                            ?>
            </div>
        </div>
    </div>
</div>
<!-- page-title area end -->
<?php   
        } elseif ( is_front_page()){?>
<div class="breadcrumb-area breadcrumb-bg only-front-page breadcrumb-spacing style-1 <?php echo $d_none; ?>">
</div>
<?php
        } elseif ( is_home()){ ?>

<!-- page-title area start-->
<div class="page-title-area overlay-bg style-1 <?php echo $d_none; ?>"
    style="<?php if (esc_attr( $bg_img )) { ?> background-image: url(<?php echo $sub_banner_img; } else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                <h1><?php print esc_html($breadcrumb_blog_title_details); ?></h1>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                }
                                else { ?>
                <h3><?php print esc_html($hostiko_blog_breadcrumb);?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                } ?>

                <?php 
                            }
                            else { ?>
                <?php
                                if (is_home() && !empty($breadcrumb_blog_title)) {
                                    // Display the breadcrumb blog title if it's the blog page and not empty
                                    ?>
                <h3 class="title"><?php echo esc_html($breadcrumb_blog_title); ?></h3>
                <?php
                                if(!empty($breadcrumb_blog_title_details)){
                    ?>
                <p><?php echo esc_html($breadcrumb_blog_title_details); ?></p>
                <?php
                                }
                                } else {
                                    // Display the default page title
                                    ?>
                <h3 class="title"><?php echo esc_html($hostiko_page_title); ?></h3>
                <?php
                                }
                                ?>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                            } ?>
                <?php 
                        if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                            ?>
                <ul class="breadcrumb">
                    <?php
                                hostiko_breadcrumbs();
                                ?>
                </ul>
                <?php
                        }
                            ?>
            </div>

        </div>
    </div>
</div>
<!-- page-title area end -->
<?php
        }
        elseif ( is_single() ) { ?>
<!-- page-title area start -->
<div class="page-title-area overlay-bg style-1 <?php echo $d_none; ?>"
    style="<?php if (esc_attr( $bg_img )) { ?> background-image: url(<?php echo $sub_banner_img; }else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row">
            <div class="col-xl-12 col-lg-12 col-12">
                <div class="col-sm-12 text-center">
                    <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                    <h1><?php echo get_the_title(); ?></h1>
                    <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                    <?php 
                                }
                                else { ?>
                    <h3> <?php print esc_html($hostiko_blog_breadcrumb);?></h3>
                    <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                    <?php 
                                } ?>
                    <?php 
                            }
                            else { ?>
                    <h3><?php echo get_the_title(); ?></h3>
                    <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                    <?php 
                            } ?>
                </div>
                <div class="col-sm-12 text-center">
                    <ul class="breadcrumb">
                        <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- page-title area end -->

<?php
        }
        elseif ( is_archive() ) {
            if($get_banner_show === 1){
                ?>
<!-- page-title area start -->
<div class="page-title-area overlay-bg style-1 <?php echo $d_none; ?>"
    style="<?php if (esc_attr( $bg_img )) { ?> background-image: url(<?php echo $sub_banner_img; }  else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if ( is_archive() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                <h1><?php echo get_the_title(); ?></h1>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                }
                                else { ?>
                <h3><?php print esc_html($hostiko_blog_breadcrumb);?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                } ?>
                <?php 
                            }
                            else { ?>
                <h3><?php echo get_the_title(); ?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                            } ?>
            </div>
            <div class="col-sm-12 text-center">
                <ul class="breadcrumb">
                    <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- page-title area end -->
<?php
            }
       }
        else { 
          if((!isset($getBannerSetting['banner_display']) || $getBannerSetting['banner_display'] == "") && $get_banner_show === '1' || $get_banner_show === 1){
            ?>
<div class="page-title-area overlay-bg style-1 <?php echo esc_attr( $d_none ); ?>" style="
        <?php 
            if ($featured_img) { 
                echo 'background-image: url(' . esc_url( get_the_post_thumbnail_url( get_the_ID(), 'full' ) ) . ');';
            } elseif (!$featured_img && !empty($sub_banner_img)) { 
                echo 'background-image: url(' . esc_url( $sub_banner_img ) . ');';
            } else { 
                echo 'background-image: url(' . esc_attr( $bg_img ) . ');';
            } 
        ?>
    ">

    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                <h1 class="title"><?php print esc_html($breadcrumb_blog_title_details); ?></h1>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                }
                                else { ?>
                <h3 class="title"> <?php print esc_html($hostiko_blog_breadcrumb);?></h3>

                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                } ?>

                <?php 
                            }
                            else {
                                $akd_theme_admin_page = get_option( 'akd-framework-admin-page' );         
                        ?>
                <?php
                if (function_exists('is_shop') && is_shop() && !empty($akd_theme_admin_page['opt-shop-title'])) {   
                            // if (is_shop() && !empty($akd_theme_admin_page['opt-shop-title'])) {
                            // Display the breadcrumb blog title if it's the blog page and not empty
                            ?>
                <h3 class="title"><?php echo esc_html($akd_theme_admin_page['opt-shop-title']); ?></h3>
                <?php
                                            if(!empty($akd_theme_admin_page['opt-blog-shop-subTitle'])){
                                ?>
                <p><?php echo esc_html($akd_theme_admin_page['opt-blog-shop-subTitle']); ?></p>
                <?php
                                            }
                                        }
                                        else{
                                            ?>
                <h3 class="title"><?php echo $hostiko_page_title?></h3>
                <?php
                }
                ?>
                <!-- <h3 class="title">< ?php wp_title(''); ?></h3> -->

                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                    echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                            } ?>
            </div>
            <div class="col-sm-12 text-center">
                <ul class="breadcrumb">
                    <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>

                </ul>
            </div>
        </div>
    </div>
</div>
<?php
        }       
    }
}
}

//hostiko_breadcrumb_style_2
function hostiko_breadcrumb_style_2() { 
    $hostiko_invisible_breadcrumb = get_post_meta( get_the_ID(), 's7template_invisible_breadcrumb', true );
    if( !$hostiko_invisible_breadcrumb ) {
        $breadcrumb_img_from_page = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_img_from_page', true);
        $breadcrumb_color_from_page = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_color', true);
        $hide_breadcrumb_bg_img = get_post_meta(get_the_ID(), 's7template_hide_breadcrumb_bg_img', true); 

        // breadcrumb bg image
        if( empty($hide_breadcrumb_bg_img ) ){

            if( $breadcrumb_img_from_page ){
                $bg_img = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_img_from_page', true);
                $bg_img = 'background-image :url('.$bg_img.')';
            }else{
                $bg_img = get_theme_mod('breadcrumb_bg_img');
                $bg_img = 'background-image :url('.$bg_img.')';    
            }    
        }else{
            $bg_img = "";
        }
        
       
        // breadcrumb color
        if( $breadcrumb_color_from_page ){
            $bg_color = get_post_meta(get_the_ID(), 's7template_breadcrumb_bg_color', true);
            $bg_color = 'background-color :'.$bg_color.'';  
        }else{
            $bg_color = get_theme_mod('breadcrumb_bg_color');
            $bg_color = 'background-color :'.$bg_color.'';    
        }

        $breadcrumb_blog_title = get_theme_mod('breadcrumb_blog_title', esc_html__('Blog ', 'hostiko'));
        $breadcrumb_blog_title_details = get_theme_mod('breadcrumb_blog_title_details', esc_html__('Read latest news from our blog & learn new things', 'hostiko'));

        $hostiko_blog_breadcrumb = get_theme_mod('hostiko_blog_breadcrumb', '');
        $featured_img = get_the_post_thumbnail_url(get_the_ID(),'full');
        if ( is_front_page() && is_home() ) { ?>

<!-- page-title area start -->
<div class="page-title-area overlay-bg style-2 <?php echo $d_none; ?>"
    style="<?php if ($featured_img) { ?> background-image: url(<?php the_post_thumbnail_url( 'full' ); } else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-sm-12 text-center">
                <h3 class="title"><?php print esc_html($breadcrumb_blog_title); ?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
            </div>
        </div>
    </div>
</div>
<!-- page-title area end -->
<?php   
        } elseif ( is_front_page()){?>
<div class="breadcrumb-area breadcrumb-bg only-front-page breadcrumb-spacing style-2">
</div>
<?php
        } elseif ( is_home()){ ?>
<!-- page-title area start-->
<div class="page-title-area overlay-bg style-2 <?php echo $d_none; ?>"
    style="<?php if (print esc_attr( $bg_img )) { ?> background-image: url(<?php the_post_thumbnail_url( 'full' ); } else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row d-flex align-items-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                <h1><?php print esc_html($breadcrumb_blog_title_details); ?></h1>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                }
                                else { ?>
                <h3> <?php print esc_html($hostiko_blog_breadcrumb);?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                } ?>
                <?php 
                            }
                            else { ?>
                <h3 class="title"><?php wp_title('');?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                            } ?>
                <ul class="breadcrumb">
                    <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>
                </ul>
            </div>

        </div>
    </div>
</div>
<!-- page-title area end -->
<?php
        }
        elseif ( is_single() ) { ?>
<!-- page-title area start -->
<div class="page-title-area overlay-bg style-2 <?php echo $d_none; ?>"
    style="<?php if (print esc_attr( $bg_img )) { ?> background-image: url(<?php the_post_thumbnail_url( 'full' ); } else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                <h3><?php wp_title(''); ?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                }
                                else { ?>
                <h3> <?php print esc_html($hostiko_blog_breadcrumb);?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                } ?>

                <?php 
                            }
                            else { ?>
                <h3><?php wp_title(''); ?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                            } ?>
            </div>
            <div class="col-sm-12 text-center">
                <ul class="breadcrumb">
                    <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- page-title area end -->
<?php
        }
        elseif ( is_archive() ) {
            if($get_banner_show === 1){
                ?>

<!-- page-title area start -->
<div class="page-title-area overlay-bg style-1 <?php echo $d_none; ?>"
    style="<?php if (print esc_attr( $bg_img )) { ?> background-image: url(<?php the_post_thumbnail_url( 'full' ); }else if (!$featured_img) { ?> background-image: url(<?php echo $sub_banner_img; }  else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if (is_archive() && 'post' == get_post_type()) {
                                // Check for the blog breadcrumb
                                if (empty($hostiko_blog_breadcrumb)) { ?>
                <h3><?php wp_title(''); ?></h3>
                <?php } else { ?>
                <h3><?php echo esc_html($hostiko_blog_breadcrumb); ?></h3>
                <?php }

                                // Display the meta content if available
                                $meta = get_post_meta(get_the_ID(), 'dbt_text', true);
                                if (!empty($meta)) {
                                    echo '<p>' . esc_html($meta) . '</p>';
                                }
                            } else { ?>
                <h3><?php wp_title(''); ?></h3>
                <?php 
                                // Display the meta content if available
                                $meta = get_post_meta(get_the_ID(), 'dbt_text', true);
                                if (!empty($meta)) {
                                    echo '<p>' . esc_html($meta) . '</p>';
                                } 
                            }
                            ?>
            </div>

            <div class="col-sm-12 text-center">
                <ul class="breadcrumb">
                    <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<!-- page-title area end -->

<?php
            }
       }
        else { if(!isset($getBannerSetting['banner_display']) || $getBannerSetting['banner_display'] == ""){ ?>
<div class="page-title-area overlay-bg style-2 <?php echo $d_none; ?>"
    style="<?php if ($featured_img) { ?> background-image: url(<?php the_post_thumbnail_url( 'full' ); } else { print esc_attr( $bg_img ); } ?>); ">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-sm-12 text-center">
                <?php 
                            if ( is_single() && 'post' == get_post_type() ) { 
                                if ( $hostiko_blog_breadcrumb == '' ) { ?>
                <h1 class="title"><?php print esc_html($breadcrumb_blog_title_details); ?></h1>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                }
                                else { ?>
                <h3 class="title"> <?php print esc_html($hostiko_blog_breadcrumb);?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                                } ?>

                <?php 
                            }
                            else { ?>
                <h3 class="title"><?php wp_title(''); ?></h3>
                <?php
                                $meta = get_post_meta(get_the_ID(),'dbt_text', true);
                                if($meta != '') {
                                echo '<p>'. $meta.' </p>';
                                }else { 
                                echo "";
                                }
                            ?>
                <?php 
                            } ?>
            </div>
            <div class="col-sm-12 text-center">
                <ul class="breadcrumb">
                    <?php 
                                    if($hostiko_breadcrumb_show && $hostiko_breadcrumb_show == 1){
                                        hostiko_breadcrumbs();
                                    }
                                 ?>
                </ul>
            </div>
        </div>
    </div>
</div>
<?php
        }       
    }
}
}
//hostiko_breadcrumbs
if(!function_exists('hostiko_breadcrumbs')) {
    function _hostiko_home_callback($home) {
        return $home;
    }
    function _hostiko_breadcrumbs_callback($breadcrumbs) {
        return $breadcrumbs;
    }
    function hostiko_breadcrumbs() {
        global $post;
        $breadcrumb_archive = get_theme_mod('breadcrumb_archive', esc_html__('Archive for category ', 'hostiko'));
        $breadcrumb_search = get_theme_mod('breadcrumb_search', esc_html__('Search results for ', 'hostiko'));
        $breadcrumb_post_tags = get_theme_mod('breadcrumb_post_tags', esc_html__('Posts tagged ', 'hostiko'));
        $breadcrumb_artitle_post_by = get_theme_mod('breadcrumb_artitle_post_by', esc_html__('Articles posted by ', 'hostiko'));
        $breadcrumb_404 = get_theme_mod('breadcrumb_404', esc_html__('Page Not Found ', 'hostiko'));
        $breadcrumb_page = get_theme_mod('breadcrumb_page', esc_html__('Page ', 'hostiko'));
        $breadcrumb_shop = get_theme_mod('breadcrumb_shop', esc_html__('Shop ', 'hostiko'));
        $breadcrumb_home = get_theme_mod('breadcrumb_home', esc_html__('Home ', 'hostiko'));
        $home = '<li class="breadcrumb-list"><a href="'.esc_url(home_url('/')).'" title="'.esc_attr($breadcrumb_home).'">'.esc_html($breadcrumb_home).'</a></li>';
        $showCurrent = 1;               
        $homeLink = esc_url(home_url('/'));
        if ( is_front_page() ) { return; }  // don't display breadcrumbs on the homepage (yet)
        print _hostiko_home_callback($home);
        if ( is_category() ) {
            // category section
            $thisCat = get_category(get_query_var('cat'), false);
            if (!empty($thisCat->parent)) print get_category_parents($thisCat->parent, TRUE, ' ' . '/' . ' ');
            print '<li class="active">'.  esc_html($breadcrumb_archive).' "' . single_cat_title('', false) . '"' . '</li>';
        } 
        elseif ( is_search() ) {
            // search section
            print '<li class="active">' .  esc_html($breadcrumb_search).' "' . get_search_query() . '"' .'</li>';
        } 
        elseif ( is_day() ) {
            print '<li class="breadcrumb-list"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a></li>';
            print '<li class="breadcrumb-list"><a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F') . '</a> </li>';
            print '<li class="active">' . get_the_time('d') .'</li>';
        } 
        elseif ( is_month() ) {
            // monthly archive
            print '<li class="breadcrumb-list"><a href="' . get_year_link(get_the_time('Y')) . '">' . get_the_time('Y') . '</a> </li>';
            print '<li class=" active">' . get_the_time('F') .'</li>';
        } 
        elseif ( is_year() ) {
            // yearly archive
            print '<li class="active">'. get_the_time('Y') .'</li>';
        } 
        elseif ( is_single() && !is_attachment() ) {
            // single post or page
            if ( get_post_type() != 'post' ) {
                $post_type = get_post_type_object(get_post_type());
                $slug = $post_type->rewrite;
                print '<li class="breadcrumb-list">';
                if ($slug && isset($slug['slug']) && $post_type && $post_type->labels && $post_type->labels->singular_name) {
                    print '<a href="' . $homeLink . '/?post_type=' . $slug['slug'] . '">' . $post_type->labels->singular_name . '</a>';
                }
                print '</li>';
                if ($showCurrent) print '<li class="active">'. get_the_title() .'</li>';
            } 
            else {
                $cat = get_the_category(); if (isset($cat[0])) {$cat = $cat[0];} else {$cat = false;}
                if ($cat) {$cats = get_category_parents($cat, TRUE, ' ' .' ' . ' ');} else {$cats=false;}
                if (!$showCurrent && $cats) $cats = preg_replace("#^(.+)\s\s$#", "$1", $cats);
                print '<li class="breadcrumb-list tajul_via">'.$cats.'</li>';
                
                if ($showCurrent) print '<li class="active">'. get_the_title() .'</li>';
            }
        } 
        elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
            // some other single item
            $post_type = get_post_type_object(get_post_type());
            print '<li class="breadcrumb-list">' . $post_type->labels->singular_name .'<li>';

            if ( 
              in_array( 
                'woocommerce/woocommerce.php', 
                apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) 
              ) 
            ) {
               if ( is_shop() && !get_query_var('paged') ) {
                    print '<span class="active">'. esc_html($breadcrumb_shop) .'</span>';
                }
            }
        } 
        elseif ( is_attachment() ) {
            // attachment section
            $parent = get_post($post->post_parent);
            $cat = get_the_category($parent->ID); if (isset($cat[0])) {$cat = $cat[0];} else {$cat=false;}
            if ($cat) print get_category_parents($cat, TRUE, ' ' . ' ' . ' ');
            print '<li class="breadcrumb-list"><a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a></li>';
            if ($showCurrent) print  '<li class="active">'. get_the_title() .'</li>';
        } 
        elseif ( is_page() && !$post->post_parent ) {

            // parent page
            if ($showCurrent) 
                print '<li class="breadcrumb-list"><a href="' . get_permalink() . '">'. get_the_title() .'</a></li>';
        } 
        elseif ( is_page() && $post->post_parent ) {
            // child page
            $parent_id  = $post->post_parent;
            $breadcrumbs = array();

            while ($parent_id) {
                $page = get_page($parent_id);
                $breadcrumbs[] = '<li class="breadcrumb-list"><a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a></li>';
                $parent_id  = $page->post_parent;
            }
            $breadcrumbs = array_reverse($breadcrumbs);
            for ($i = 0; $i < count($breadcrumbs); $i++) {
                print _hostiko_breadcrumbs_callback($breadcrumbs[$i]);
                if ($i != count($breadcrumbs)-1);
            }
            if ($showCurrent) print '<li class="active">'. get_the_title() .'</li>';
        } 
        elseif ( is_tag() ) {
            // tags archive
            print '<li class="breadcrumb-list">' .  esc_html($breadcrumb_post_tags).' "' . single_tag_title('', false) . '"' . '</li>';
        } 
        elseif ( is_author() ) {
            // author archive 
            global $author;
            $userdata = get_userdata($author);
            print '<li class="breadcrumb-list">' .  esc_html($breadcrumb_artitle_post_by). ' ' . $userdata->display_name . '</li>';
        } 
        elseif ( is_404() ) {
            // 404
            print '<li class="active salim">'. esc_html($breadcrumb_404) .'</li>';
        }
      
        if ( get_query_var('paged') ) {


            if ( 
              in_array( 
                'woocommerce/woocommerce.php', 
                apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) 
              ) 
            ) {
                if ( is_shop() ) {
                    print '<span class="active">'. esc_html($breadcrumb_page) . ' ' . get_query_var('paged') .'</span>';
                }
                else {
                    if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) print '<li class="breadcrumb-list"> (';
                    print  '<li class="active">'.esc_html($breadcrumb_page) . ' ' . get_query_var('paged').'</li>';
                    if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) print ')</li>';
                }
            }
        }
    }
}


//hostiko footer
add_action('hostiko_footer_style', 'hostiko_check_footer', 10);
function hostiko_check_footer() {
    if(isset($_GET['view'])){
        $view_perameter = $_GET['view'];
        if($view_perameter == "agriculture"){
            $hostiko_footer_e = get_theme_mod('choose_elementor_footer');
            echo Elementor\Plugin::instance()
           ->frontend
               ->get_builder_content_for_display(9225);
        }
        if($view_perameter == "bakery"){
           $hostiko_footer_e = get_theme_mod('choose_elementor_footer');
           echo Elementor\Plugin::instance()
          ->frontend
              ->get_builder_content_for_display(9234);
       }
       if($view_perameter == "sushi"){
           $hostiko_footer_e = get_theme_mod('choose_elementor_footer');
           echo Elementor\Plugin::instance()
          ->frontend
              ->get_builder_content_for_display(9258);
       }
       if($view_perameter == "catering"){
           $hostiko_footer_e = get_theme_mod('choose_elementor_footer');
           echo Elementor\Plugin::instance()
          ->frontend
              ->get_builder_content_for_display(9246);
       }
   }
   else{
       $hostiko_footer_style = get_post_meta( get_the_ID(), 's7template_choice_footer_style', true );
       $hostiko_default_footer_style = get_theme_mod('choose_default_footer', 'footer-style-1' );
       if( $hostiko_footer_style == 'footer-style-1' ) {
           hostiko_footer_style_1();
       }
       else{
          hostiko_footer_style_2();
       }
   }
}


//footer  style 1
function hostiko_footer_style_1() {
    $hostiko_footer_bg_url_from_page = get_post_meta( get_the_ID(), 's7template_footer_bg', true );
    $hostiko_footer_bg_color_from_page = get_post_meta( get_the_ID(), 's7template_footer_bg_color', true );
    $hostiko_footer_type = get_theme_mod('footer_source_type');
    $hostiko_footer_e = get_theme_mod('hostiko_footer_elementor_templates');
    if( $hostiko_footer_bg_url_from_page ){
        $bg_img = get_post_meta( get_the_ID(), 's7template_footer_bg', true );
    }else{
        $bg_img = get_theme_mod('hostiko_footer_bg');
    }  
    if( $hostiko_footer_bg_color_from_page ){
        $bg_color = get_post_meta( get_the_ID(), 's7template_footer_bg_color', true );
    }else{
        $bg_color = get_theme_mod('hostiko_footer_bg_color');
    }    
    $enable_footer_widgets = get_theme_mod('hostiko_enable_footer_widgets');  
?>
</div>

<!-- footer area start -->
<footer class="footer-area style-2"
    style="background-image :url(<?php print esc_url($bg_img); ?> );  background-color: <?php print esc_attr( $bg_color ); ?>">
    <?php 
    if($enable_footer_widgets) :
        if( is_active_sidebar( 'footer-widget-1' ) || is_active_sidebar( 'footer-widget-2' ) || is_active_sidebar( 'footer-widget-3' ) || is_active_sidebar( 'footer-widget-4' ) ): ?>
    <div class="footer-top">
        <div class="container">
            <div class="row custom-gutter">

                <?php 
                        if ( is_active_sidebar( 'footer-widget-1' ) ): ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <?php dynamic_sidebar( 'footer-widget-1' ); ?>
                </div>
                <?php 
                        endif; ?>

                <?php 
                        if ( is_active_sidebar( 'footer-widget-2' ) ): ?>
                <div class="col-xl-2 col-lg-6 col-md-6">
                    <?php dynamic_sidebar( 'footer-widget-2' ); ?>
                </div>
                <?php 
                        endif; ?>

                <?php 
                        if ( is_active_sidebar( 'footer-widget-3' ) ): ?>
                <div class="col-xl-3 col-lg-3 col-md-3">
                    <?php dynamic_sidebar( 'footer-widget-3' ); ?>
                </div>
                <?php 
                        endif; ?>

                <?php 
                        if ( is_active_sidebar( 'footer-widget-4' ) ): ?>
                <div class="col-xl-3 col-lg-3 col-md-3">
                    <?php dynamic_sidebar( 'footer-widget-4' ); ?>
                </div>
                <?php 
                        endif; ?>
            </div>
        </div>
    </div>
    <?php 
        endif; 
    endif; ?>
    <?php
        if ('e' === $hostiko_footer_type) {
            echo Elementor\Plugin::instance()
            ->frontend
                ->get_builder_content_for_display($hostiko_footer_e);
        }
    ?>
    <div class="footer-bottom">
        <div class="container">
            <div class="row">
                <?php 
                if( is_active_sidebar( 'footer-menu' ) ): ?>

                <div class="col-lg-7 text-lg-left text-center">
                    <?php dynamic_sidebar( 'footer-menu' ); ?>
                </div>
                <div class="col-lg-5 text-center text-lg-right">
                    <p class="copyright">
                        <?php hostiko_copyright_text(); ?>
                    </p>
                </div>
                <?php 
                else: ?>
                <div class="col-lg-12 text-center">
                    <p class="copyright">
                        <?php hostiko_copyright_text(); ?>
                    </p>
                </div>
                <?php 
                endif; ?>
            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->
<?php 
}


//footer  style 2
function hostiko_footer_style_2() {
    $hostiko_footer_bg_url_from_page = get_post_meta( get_the_ID(), 's7template_footer_bg', true );
    $hostiko_footer_bg_color_from_page = get_post_meta( get_the_ID(), 's7template_footer_bg_color', true );
    $hostiko_footer_type = get_theme_mod('footer_source_type');
    $hostiko_footer_e = get_theme_mod('hostiko_footer_elementor_templates');
    if( $hostiko_footer_bg_url_from_page ){
            $bg_img = get_post_meta( get_the_ID(), 's7template_footer_bg', true );
    }else{
            $bg_img = get_theme_mod('hostiko_footer_bg');
    }  
    if( $hostiko_footer_bg_color_from_page ){
            $bg_color = get_post_meta( get_the_ID(), 's7template_footer_bg_color', true );
    }else{
            $bg_color = get_theme_mod('hostiko_footer_bg_color');
    }    
    $enable_footer_widgets = get_theme_mod('hostiko_enable_footer_widgets');  
?>
</div>

<!-- footer area start -->
<footer class="footer-area style-3"
    style="background-image :url(<?php print esc_url($bg_img); ?> );  background-color: <?php print esc_attr( $bg_color ); ?>">

    <?php 
    if($enable_footer_widgets) :
        if( is_active_sidebar( 'footer-widget-1' ) || is_active_sidebar( 'footer-widget-2' ) || is_active_sidebar( 'footer-widget-3' ) || is_active_sidebar( 'footer-widget-4' ) ): ?>
    <div class="footer-top">
        <div class="container">
            <div class="row custom-gutter">

                <?php 
                        if ( is_active_sidebar( 'footer-widget-1' ) ): ?>
                <div class="col-xl-4 col-lg-6 col-md-6">
                    <?php dynamic_sidebar( 'footer-widget-1' ); ?>
                </div>
                <?php 
                        endif; ?>

                <?php 
                        if ( is_active_sidebar( 'footer-widget-2' ) ): ?>
                <div class="col-xl-2 col-lg-6 col-md-6">
                    <?php dynamic_sidebar( 'footer-widget-2' ); ?>
                </div>
                <?php 
                        endif; ?>

                <?php 
                        if ( is_active_sidebar( 'footer-widget-3' ) ): ?>
                <div class="col-xl-3 col-lg-3 col-md-3">
                    <?php dynamic_sidebar( 'footer-widget-3' ); ?>
                </div>
                <?php 
                        endif; ?>

                <?php 
                        if ( is_active_sidebar( 'footer-widget-4' ) ): ?>
                <div class="col-xl-3 col-lg-3 col-md-3">
                    <?php dynamic_sidebar( 'footer-widget-4' ); ?>
                </div>
                <?php 
                        endif; ?>

            </div>
        </div>
    </div>
    <?php 
        endif; 
    endif; ?>
    <?php
        if ('e' === $hostiko_footer_type) {
            echo Elementor\Plugin::instance()
            ->frontend
                ->get_builder_content_for_display($hostiko_footer_e);
        }
    ?>
    <div class="footer-bottom">
        <div class="container">
            <div class="row">
                <?php 
                if( is_active_sidebar( 'footer-menu' ) ): ?>

                <div class="col-lg-7 text-lg-left text-center">
                    <?php dynamic_sidebar( 'footer-menu' ); ?>
                </div>
                <div class="col-lg-5 text-center text-lg-right">
                    <p class="copyright">
                        <?php hostiko_copyright_text(); ?>
                    </p>
                </div>

                <?php 
                else: ?>

                <div class="col-lg-12 text-center">
                    <p class="copyright">
                        <?php hostiko_copyright_text(); ?>
                    </p>
                </div>
                <?php 
                endif; ?>

            </div>
        </div>
    </div>
</footer>
<!-- footer area end -->
<?php 
}


//copyright info
function hostiko_copyright_text(){
    echo esc_html(get_theme_mod('hostiko_copyright', esc_html__('Copyright &copy; Hostiko 2023. All rights reserved','hostiko')));
}


//back to top area start 
add_action('hostiko_footer_style', 'hostiko_scrollTop', 15);
function hostiko_scrollTop(){
    $scrollTop = get_theme_mod('hostiko_scrollup_switch', false);
    if($scrollTop == true) :?>
<div class="back-to-top">
    <span class="back-top"><i class="fa fa-long-arrow-up"></i></span>
</div>
<?php 
    endif; 
}


//post-format
add_action('admin_print_scripts', 'hostiko_scripts_for_admin_panel', 1000);
function hostiko_scripts_for_admin_panel(){
    if( get_post_type() == 'post' ) :
    ?>
<script>
(function($) {
    "use strict";
    jQuery(document).ready(function() {
        var hostiko = jQuery("input[name='post_format']:checked").attr('id');
        if (hostiko == 'post-format-video') {
            jQuery('.cmb2-id--video-url').show();
        } else {
            jQuery('.cmb2-id--video-url').hide();
        }
        if (hostiko == 'post-format-audio') {
            jQuery('.cmb2-id--audio-url').show();
        } else {
            jQuery('.cmb2-id--audio-url').hide();
        }
        if (hostiko == 'post-format-gallery') {
            jQuery('.cmb2-id--gallery-images').show();
        } else {
            jQuery('.cmb2-id--gallery-images').hide();
        }

        jQuery('input[name="post_format"]').change(function() {
            var hostiko = jQuery("input[name='post_format']:checked").attr('id');
            if (hostiko == 'post-format-video') {
                jQuery('.cmb2-id--video-url').show();
            } else {
                jQuery('.cmb2-id--video-url').hide();
            }
            if (hostiko == 'post-format-audio') {
                jQuery('.cmb2-id--audio-url').show();
            } else {
                jQuery('.cmb2-id--audio-url').hide();
            }

            if (hostiko == 'post-format-gallery') {
                jQuery('.cmb2-id--gallery-images').show();
            } else {
                jQuery('.cmb2-id--gallery-images').hide();
            }
        });
    })
})(jQuery);
</script>
<?php endif;
}