<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package hostiko
 */
$hostikoTag = hostiko_Function('Tags');
$hostikoFunc = hostiko_Function('Functions');
$hostiko_tg = hostiko_Function('Tags');
$akd_theme_admin_page = get_option( 'akd-framework-admin-page' );

if( is_single() ): ?>
<article id="post-<?php the_ID(); ?>" <?php post_class('standard-postbox-details'); ?>>
    <div class="blog-details-inner">
        <div class="blog-details-content">
            <?php 
			if ( has_post_thumbnail() ) : ?>
            <div class="thumb border-thumb">
                <div class="blog-thumb-full d-flex">
                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'full')?>"
                        alt="<?php echo get_post_meta( get_post_thumbnail_id(), '_wp_attachment_image_alt', true);?>">
                </div>
            </div>
            <?php 
			endif; ?>

            <div class="blog-item-info">
                <h3><?php the_title(); ?></h3>
                <ul class="post-meta">
                    <li class="post-author"><?php $hostiko_tg->posted_by(); ?></li>
                    <li class="post-date"><?php $hostiko_tg->posted_on(); ?></li>
                </ul>
            </div>

            <div class="st-blog-content-detils">

                <?php 
				if( has_excerpt() ): ?>
                <div class="short-summary-content">
                    <?php the_excerpt(); ?>
                </div>
                <?php 
				endif; ?>

                <?php
					the_content( sprintf(
						wp_kses(
							/* translators: %s: Name of current post. Only visible to screen readers */
							__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'hostiko' ),
							array(
								'span' => array(
									'class' => array(),
								),
							)
						),
						get_the_title()
					) );
					
					$hostikoFunc->link_pages(); 
				?>
            </div>

            <?php 
			 if( has_tag() ) : ?>
            <div class="blog-details_bottom">
                <?php $hostiko_tg->tags(); ?>
            </div>
            <?php 
			endif; ?>
        </div>
    </div>

</article><!-- #post-<?php the_ID(); ?> -->

<?php 
else: ?>
<?php
$blog_item_cols = 12;
if(isset($akd_theme_admin_page['opt-image-select-blog-grid'])){
    
    if($akd_theme_admin_page['opt-image-select-blog-grid'] == 'single'){
        $blog_item_cols = 12;
    }
    else if($akd_theme_admin_page['opt-image-select-blog-grid'] == 'two-column'){
        $blog_item_cols = 6;
    }
    else if($akd_theme_admin_page['opt-image-select-blog-grid'] == 'three-column'){
        $blog_item_cols = 4;
    }
}
?>
<div class="single-blog-wrap standard-postbox <?php echo 'col-lg-'.$blog_item_cols; ?>">
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

        <!-- blog-item-->
        <div class="blog-item">

            <?php 
			if ( has_post_thumbnail() ) : ?>
            <div class="thumb">
                <a href="<?php the_permalink( ); ?>">
                    <img src="<?php echo get_the_post_thumbnail_url(get_the_ID(),'hostiko-main-blog')?>"
                        alt="<?php the_title(); ?>">
                </a>
            </div>
            <?php 
			endif; ?>

            <div class="blog-details">

                <?php 
				if( ! empty( $post->post_title ) ) : ?>
                <h5 class="blog-item-title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h5>
                <?php 
				endif; ?>

                <span><i class="fa fa-user"></i><?php $hostikoTag->posted_by(); ?></span>

                <?php
				if(isset($akd_theme_admin_page['opt-switcher-show-date']) && $akd_theme_admin_page['opt-switcher-show-date']){
				?>
                <span><i class="fa fa-clock-o"></i><?php $hostikoTag->posted_on(); ?></span>
                <?php
				}
				?>

                <?php
				if(isset($akd_theme_admin_page['opt-switcher-show-excerpt']) && $akd_theme_admin_page['opt-switcher-show-excerpt']){
				?>
                <?php the_excerpt(); ?>
                <?php
				}
				?>

                <?php
				if(isset($akd_theme_admin_page['opt-switcher-show-readmore']) && $akd_theme_admin_page['opt-switcher-show-readmore']){
				?>
                <div class="blog-btn">
                    <a class="read-more-btn"
                        href="<?php the_permalink();?>"><?php esc_html_e("Read More", "hostiko");?><i
                            class="fa fa-long-arrow-right"></i></a>
                </div>
                <?php
				}
				?>
            </div>
        </div>
    </article>
</div>
<?php endif; ?>