<?php

/**
 * The admin-specific functionality of the plugin.
 *
 * @link       https://http://designingmedia.com/
 * @since      1.0.0
 *
 * @package    Akd_Framework
 * @subpackage Akd_Framework/admin
 */

/**
 * The admin-specific functionality of the plugin.
 *
 * @package    Akd_Framework
 * @subpackage Akd_Framework/admin
 * @author     Ammar Nasir <info@domain.com>
 */
trait Akd_Required_plugin_Activation {

	/**
	 * Method to prepare list of theme's required plugins
	 */
	public function akd_register_required_plugins() {
		/*
		* Array of plugin arrays. Required keys are name and slug.
		* If the source is NOT from the .org repo, then source is also required.
		*/

		$plugins = array(

			array(
				'name'     => __( 'Elementor Page Builder', 'akd-demo-importer' ),
				'slug'     => 'elementor',
				'required' => true,
			),
			array(
				'name'     => __( 'Hostiko Toolkit', 'akd-demo-importer' ),
				'slug'     => 'hostiko-toolkit',
				'source'   => plugin_dir_path( dirname( __FILE__ ) ) . 'admin/plugins/hostiko-toolkit.zip',
				'required' => true,
			),
			array(
				'name'     => __( 'Contact Form 7', 'akd-demo-importer' ),
				'slug'     => 'contact-form-7',
				'required' => true,
			),
			array(
				'name'     => __( 'WooCommerce', 'akd-demo-importer' ),
				'slug'     => 'woocommerce',
				'required' => false,
			),
			array(
				'name'     => __( 'Classic Editor', 'akd-demo-importer' ),
				'slug'     => 'classic-editor',
				'required' => false,
			),

			array(
				'name'     => __( 'Revolution Slider', 'akd-demo-importer' ),
				'source'   => plugin_dir_path( dirname( __FILE__ ) ) . 'admin/plugins/revslider.zip',
				'slug'     => 'revslider',
				'required' => true,
			),
			array(
				'name'     => __( 'GDPR Cookie Compliance', 'akd-demo-importer' ),
				'slug'     => 'gdpr-cookie-compliance',
				'required' => false,
			),
		);

		/*
		* Array of configuration settings. Amend each line as needed.
		*
		* TGMPA will start providing localized text strings soon. If you already have translations of our standard
		* strings available, please help us make TGMPA even better by giving us access to these translations or by
		* sending in a pull-request with .po file(s) with the translations.
		*
		* Only uncomment the strings in the config array if you want to customize the strings.
		*/
		$config = array(
			'id'           => 'tettram',                 // Unique ID for hashing notices for multiple instances of TGMPA.
			'default_path' => '',                      // Default absolute path to bundled plugins.
			'menu'         => 'tgmpa-install-plugins', // Menu slug.
			'has_notices'  => false,                    // Show admin notices or not.
			'dismissable'  => true,                    // If false, a user cannot dismiss the nag message.
			'dismiss_msg'  => '',                      // If 'dismissable' is false, this message will be output at top of nag.
			'is_automatic' => false,                   // Automatically activate plugins after installation or not.
			'message'      => '',                      // Message to output right before the plugins table.

		);

		tgmpa( $plugins, $config );
	}
}
