(function( $ ) {
	'use strict';

	/**
	 * All of the code for your admin-facing JavaScript source
	 * should reside in this file.
	 *
	 * Note: It has been assumed you will write jQuery code here, so the
	 * $ function reference has been prepared for usage within the scope
	 * of this function.
	 *
	 * This enables you to define handlers, for when the DOM is ready:
	 *
	 * $(function() {
	 *
	 * });
	 *
	 * When the window is loaded:
	 *
	 * $( window ).load(function() {
	 *
	 * });
	 *
	 * ...and/or other possibilities.
	 *
	 * Ideally, it is not considered best practise to attach more than a
	 * single DOM-ready or window-load handler for a particular page.
	 * Although scripts in the WordPress core, Plugins and Themes may be
	 * practising this, we should strive to set a better example in our own work.
	 */

	 $(document).ready(function(){
		themeActivationContent();
		envatoPurchaseCodeValidation();
		minorJsCode();
		changeCodestarTabContent();
		changeCodestarActiveItem();
		disconnectDomain();
		installChildTheme();
		downloadThemeFiles();
		downloadImportFiles();
		akdSyncWhmcs();
		newDemoLayoutTrigger();
		akdImportSingleLayout();

		jQuery(document).ready(function($) {
			let initialData = {};

			// Store initial values correctly
			function storeInitialValues() {
				$('#csf-form :input').each(function () {
					let name = $(this).attr('name');
					if (name && $(this).val() !== undefined) {
						initialData[name] = $(this).val();
					}
				});
			}

			// Call function to store initial values
			setTimeout(function(){
				storeInitialValues();
			},2000);
		
			// Intercept the form submission
			$('#csf-form').on('submit', function(e) {
				e.preventDefault(); // Prevent normal form submission
		
				let changedData = {};
				let formData = $(this).serializeArray(); // Get form data
		
				// Compare current values with initial values
				$.each(formData, function (_, field) {
					if (initialData.hasOwnProperty(field.name) && initialData[field.name] !== field.value) {
						changedData[field.name] = field.value;
					}
				});

				// Debugging: Log detected changes
				//console.log('Changed Fields:', changedData);
		
				if ($.isEmptyObject(changedData)) {
					alert('No changes detected!');
					return;
				}

				// New object to store cleaned data
				let cleaned_data = {};

				// Debugging: Log each key format
				// console.log("Keys Before Processing:", Object.keys(changedData));

				// Loop through each key in the original object
				Object.keys(changedData).forEach((key) => {
					// console.log("Processing Key:", key); // Log each key
					let match = key.match(/akd-framework-admin-page\[(.*?)\]/); // Adjusted regex

					if (match) {
						let subKey = match[1]; // Extract subkey like "opt-subBannerImage"
						cleaned_data[`${subKey}`] = changedData[key];
					} else {
						cleaned_data[key] = changedData[key]; // Keep unchanged keys
					}
				});

				// Debugging: Log cleaned data
				// console.log("Cleaned Data:", cleaned_data);
				
				// Send the changed data via AJAX
				$.ajax({
					url: ajaxurl, // WordPress AJAX handler
					type: 'POST',
					data: {
						action: 'update_codestar_fields',
						changed_data: cleaned_data
					},
					beforeSend: function() {
						$('.csf-top-save').text('Saving...').prop('disabled', true);
					},
					success: function(response) {
						// alert(response.data.message);
						$('.csf-form-success').text(response.data.message);
						$('.csf-top-save').text('Save').prop('disabled', false);
						$('.csf-form-success').show();
						// Allow form to continue submission after AJAX success
						$('#csf-form').off('submit').submit();
					},
					error: function() {
						// alert('Error updating settings.');
						$('.csf-form-warning').text('Error updating settings.');
						$('.csf-top-save').text('Save').prop('disabled', false);
						$('.csf-form-warning').show();
					}
				});
			});
		});
		
		
		
		
		
	});

	function akdSyncWhmcs(){

		$('input[name="akd-framework-admin-page[akd-whmcs-api-identifier]"]').attr('type', 'password');
		$('input[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').attr('type', 'password');
		$('input[name="akd-framework-admin-page[akd-whmcs-api-identifier]"]').val(akd_localization_data.whmcs_identifier ? akd_localization_data.whmcs_identifier : '');
		$('input[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').val(akd_localization_data.whmcs_secret ? akd_localization_data.whmcs_secret : '');

		if(akd_localization_data.whmcs_url && akd_localization_data.whmcs_identifier){
			$('[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').parent().parent().after('<div class="akd-notice-container"><div class="akd-notice-box"><strong>Note:</strong> WHMCS integration is required for Domain Search and WHMCS Product Listing.</div></div> <div class="csf-field"> <button type="button" class="button-primary sync_whmcs" id="re_sync_whmcs" value="re_sync_whmcs">Re-Sync</button> </div>');
		} else {
			$('[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').parent().parent().after('<div class="akd-notice-container"><div class="akd-notice-box"><strong>Note:</strong> WHMCS integration is required for Domain Search and WHMCS Product Listing.</div></div> <div class="csf-field"> <button type="button" class="button-primary sync_whmcs" id="sync_whmcs" value="sync_whmcs">Authenticate & Sync</button> </div> ');
		}
		
		$(document).on('click', '#sync_whmcs', function(){

			let content = `
				<div class="akd-wrapper">
					<div class="akd-loader-container">
					<div class="akd-loader"></div>
					</div>
				</div>
			`;
			$('.csf-options').append(content);

			let whm_url = $('[name="akd-framework-admin-page[akd-whmcs-api]"]').val();
			let whm_secret = $('[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').val();
			let whm_identifier = $('[name="akd-framework-admin-page[akd-whmcs-api-identifier]"]').val();
			if(whm_url != '' && whm_secret != '' && whm_identifier != ''){
				$.ajax({
					type : "POST",
					url: akd_localization_data.urls_to_frontend.ajaxUrl,
					data: {
						action: 'akd_validate_whmcs_url',
						url: whm_url,
					},
					success: function(res){
						let whmcs_url_validate =  JSON.parse(res);
						if(whmcs_url_validate.type == 'success'){
							$.ajax({
								type: "POST",
								url: akd_localization_data.urls_to_frontend.ajaxUrl,
								data: {
									action: 'akd_check_whmcs_url',
									url: whm_url,
								},
								success: function(res) {
									let curl_data = JSON.parse(res);
									if(curl_data.type == 'success'){
										$.ajax({
											url: akd_localization_data.urls_to_frontend.ajaxUrl,
											type: "POST",
											data: {
												action: 'akd_get_whmcs_groups',
												url: whm_url,
												secret: whm_secret,
												identifier: whm_identifier,
											},
											success: function (res) {

												let data = JSON.parse(res);
												console.log(data);
												if (data.type == 'success') {
													$('.akd-wrapper').remove();
													$('.validate-error').remove();
													$('.validate-success').remove();
													$('.sync_whmcs').after('<div class="validate-success" style="margin-top:20px"> '+data.msg+' </div>')
													setTimeout(function(){
														$('.csf-top-save').click();
													}, 3000);
												} else if (data.type == 'error') {
													$('.akd-wrapper').remove();
													$('.validate-error').remove();
													$('.validate-success').remove();
													$('.sync_whmcs').after('<div class="validate-error"> '+data.msg+' </div>')
												}
											},
											error: function (xhr, status, error) {
												$('.akd-wrapper').remove();
												console.log("Error:", error);
											}
										});
										$.ajax({
											url: akd_localization_data.urls_to_frontend.ajaxUrl,
											type: "POST",
											data: {
												action: 'akd_get_whmcs_tlds',
												url: whm_url,
												secret: whm_secret,
												identifier: whm_identifier,
											},
											success: function (res) {
												let data = JSON.parse(res);
												console.log(data);
												
											},
											error: function (xhr, status, error) {
												console.log("Error:", error);
											}
										});
									}
									else if (curl_data.type == 'error') {
										$('.akd-wrapper').remove();
										$('.validate-error').remove();
										$('.validate-success').remove();
										$('.sync_whmcs').after('<div class="validate-error"> '+curl_data.msg+' </div>')
									}
								},
								error: function(res){
									console.log(res);
								}
							});
						}else{
							$('.akd-wrapper').remove();
							$('.validate-error').remove();
							$('.validate-success').remove();
							$('.sync_whmcs').after('<div class="validate-error"> '+whmcs_url_validate.msg+' </div>')
						}
					}
				});
			} else {
				$('.akd-wrapper').remove();
				$('.validate-error').remove();
				$('.validate-success').remove();
				$('.sync_whmcs').after('<div class="validate-error"> Some Fields can not be empty!!! </div>')
			}

		});

		$(document).on('click', '#re_sync_whmcs', function(){
			
			let content = `
				<div class="akd-wrapper">
					<div class="akd-loader-container">
					<div class="akd-loader"></div>
					</div>
				</div>
			`;
			$('.csf-options').append(content);
	
			let whm_url = $('[name="akd-framework-admin-page[akd-whmcs-api]"]').val();
			let whm_secret = $('[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').val();
			let whm_identifier = $('[name="akd-framework-admin-page[akd-whmcs-api-identifier]"]').val();
			if(whm_url != '' && whm_secret != '' && whm_identifier != ''){
				$.ajax({
					type : "POST",
					url: akd_localization_data.urls_to_frontend.ajaxUrl,
					data: {
						action: 'akd_validate_whmcs_url',
						url: whm_url,
					},
					success: function(res){
						let whmcs_url_validate =  JSON.parse(res);
						if(whmcs_url_validate.type == 'success'){
							$.ajax({
								type: "POST",
								url: akd_localization_data.urls_to_frontend.ajaxUrl,
								data: {
									action: 'akd_check_whmcs_url',
									url: whm_url,
								},
								success: function(res) {
									let curl_data = JSON.parse(res);
									if(curl_data.type == 'success'){
										$.ajax({
											url: akd_localization_data.urls_to_frontend.ajaxUrl,
											type: "POST",
											data: {
												action: 'akd_get_groups_resync',
												url: whm_url,
												secret: whm_secret,
												identifier: whm_identifier,
											},
											success: function (res) {
				
												let data = JSON.parse(res);
												console.log(data);
												if (data.type == 'success') {
													$('.akd-wrapper').remove();
													$('.validate-error').remove();
													$('.validate-success').remove();
													$('.sync_whmcs').after('<div class="validate-success"  style="margin-top:20px"> '+data.msg+' </div>')
													setTimeout(function(){
														$('.csf-top-save').click();
													}, 3000);
												} else if (data.type == 'error') {
													$('.akd-wrapper').remove();
													$('.validate-error').remove();
													$('.validate-success').remove();
													$('.sync_whmcs').after('<div class="validate-error"> '+data.msg+' </div>')
												}
											},
											error: function (xhr, status, error) {
												$('.akd-wrapper').remove();
												console.log("Error:", error);
											}
										});
										
									}
									else if (curl_data.type == 'error') {
										$('.akd-wrapper').remove();
										$('.validate-error').remove();
										$('.validate-success').remove();
										$('.sync_whmcs').after('<div class="validate-error"> '+curl_data.msg+' </div>')
									}
								},
								error: function(res){
									console.log(res);
								}
							});
						}else{
							$('.akd-wrapper').remove();
							$('.validate-error').remove();
							$('.validate-success').remove();
							$('.sync_whmcs').after('<div class="validate-error"> '+whmcs_url_validate.msg+' </div>')
						}
					}
				});
			} else{
				$('.akd-wrapper').remove();
				$('.validate-error').remove();
				$('.validate-success').remove();
				$('[name="akd-framework-admin-page[akd-whmcs-api-secret]"]').parent().parent().after('<div class="validate-error"> Some Fields can not be empty!!! </div>')
			}
		});
	}

	//method to disconnect domain
	function disconnectDomain(){
		$(document).on('click', '.akd-disconnect-domain', function(e){
			e.preventDefault();

			if($(this).data('purchase-code')){
				sessionStorage.removeItem('activeTab');

				let data = {
					action: 'disconnect_domain',
					'purchaseCode' : $(this).data('purchase-code') ? $(this).data('purchase-code') : '',
				}
	
				whmcsAjaxCall(data, $(this));
			}
		});
	}

	//method to add additoinal HTML content for the theme activatation screen
	function themeActivationContent(){
		// Cache the jQuery selectors
		let radioButtons = $('input[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-options]"]');
		let ulParent = radioButtons.closest('ul');
		
		// Function to create custom HTML based on the selected radio button
		function createCustomHTML(activationMethod) {
			let akdActivationHtml = '';
			if (activationMethod === 'purchase-code') {
				akdActivationHtml = `<li class="akd-act-field">
						<label>
							<span class="akd-purchase-code akd-label">Envato Purchase code <sup class="required">*</sup></span>
							<input type="password" name="akd_theme_purchase_code" placeholder="Envato Purchase code (required)" />
							<div class="akd-notice-container">
								<div class="akd-notice-box">
									Need help locating your purchase code? <a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-" target="_blank">Use this guide.</a>
								</div>
							</div>
							<button class="akd-validate-envato-code button-primary" value="Validate Purchase Code">Validate Purchase Code <i class="fa fa-spinner loader akd-btn-loader-animation"></i></button>
						</label>
				</li>`;
			} else if (activationMethod === 'get-purchase-code') {
				akdActivationHtml = `<li class="akd-act-field">
					<label>
						<span class="akd-purchase-code akd-label">Envato Elements Token <sup class="required">*</sup></span>
						<input type="text" name="akd_theme_purchase_code" placeholder="Envato Purchase Code (required)">
						<div class="akd-notice-container">
							<div class="akd-notice-box">
								<a href="#" target="_blank">Nevigate to this link</a> to generate Envato Elements Token to activate your Hostiko theme.
							</div>
						</div>
						<button class="akd-validate-envato-code button-primary" value="Validate Purchase Code">Validate Purchase Code <i class="fa fa-spinner loader akd-btn-loader-animation"></i></button>
					</label>
				</li>`;
			}

			$('.validate-error').remove();
			$('.validate-success').remove();
			return akdActivationHtml;
		}
		
		// Function to append custom HTML to the UL
		function appendCustomHTML(html) {
			ulParent.append(html);
		}
		
		// On page load
		let initialActivationMethod = radioButtons.filter(':checked').val();
		appendCustomHTML(createCustomHTML(initialActivationMethod));
		
		// On change
		radioButtons.change(function() {
			// Remove existing custom HTML
			$('.akd-act-field').remove();
			
			// Create and append new custom HTML based on the selected radio button
			let akdActivationMethod = $(this).val();
			appendCustomHTML(createCustomHTML(akdActivationMethod));
		});
	}

	//method to validate envato purchase code
    function envatoPurchaseCodeValidation(){
        //send ajax request
        $(document).on('click', '.akd-validate-envato-code', function(e){
			e.preventDefault();
			$('.loader').css('display', 'inline-block');
			let emailPattern = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
			if($('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-name]"]').val() != '' && $('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-email]"]').val() != ''){
				if($('[name="akd_theme_purchase_code"]').val() != '' && emailPattern.test($('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-email]"]').val())){
					let data = {
						action: 'validate_purchase_code',
						'purchaseCode' : $('[name="akd_theme_purchase_code"]').val() ? $('[name="akd_theme_purchase_code"]').val() : '',
						'name' : $('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-name]"]').val() ? $('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-name]"]').val() : '',
						'email' : $('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-email]"]').val() ? $('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-email]"]').val() : '',
					}
	
					whmcsAjaxCall(data, $(this));
				} else if(!emailPattern.test($('[name="akd-framework-admin-page[akd-theme-dashboard][akd-act-email]"]').val())){
					$('.loader').hide();
					$('.validate-error').remove();
					$(this).parent().parent().after('<div class="validate-error"> Please enter valid email address. </div>')
				} else {
					$('.loader').hide();
					$('.validate-error').remove();
					$(this).parent().parent().after('<div class="validate-error"> Please add your purchase code first. </div>')
				}
			} else {
				$('.loader').hide();
				$('.validate-error').remove();
				$(this).parent().parent().after('<div class="validate-error"> Name and email is required. </div>')
			}
        });
    }

	//method to trigger ajax call
    function whmcsAjaxCall(data, currentElement){
        $.ajax({
            type: 'POST',
            url: akd_localization_data.urls_to_frontend.ajaxUrl,
            data: data,
            success: function(response) {
                if(response.success === true && response.data != undefined && response.data.status !== 'false'){
					$('.loader').hide();
                    $('.validate-success').remove();
                    $('.validate-error').remove();
                    currentElement.parent().parent().after('<div class="validate-success"> '+response.data.message+' </div>')
                    setTimeout(function(){
                        $('.csf-top-save').click();
                    }, 4000);
                } else if(response.success === false && response.data != undefined){
					$('.loader').hide();
                    $('.validate-error').remove();
					$('.validate-success').remove();
                    currentElement.parent().parent().after('<div class="validate-error"> '+response.data.message+' </div>')
                }else if(response.success === true && response.data != undefined  && response.data.status === 'false'){
					$('.loader').hide();
                    $('.validate-success').remove();
                    $('.validate-error').remove();
                    currentElement.parent().parent().after('<div class="validate-error"> '+response.data.message+' </div>')
                    setTimeout(function(){
                        $('.csf-top-save').click();
                    }, 4000);
                }
            },
            error: function(error) {
                return error
            }
        });
    }

	//method to change tab content based on active tab
    function changeCodestarTabContent() {
		$(document).on('click', '.csf-tabbed-nav', function(){
			let content = '';
			if($(this).find('.csf-tabbed-active').text() === 'Plugins'){
				//if theme is not activated then show alert in the plugins tab
				if(!akd_localization_data.additional_data.purchaseCode){
					content += `
						<div class="csf-field csf-plugins">
							<div class="plugin-container">
								<p> Activate your theme in order to be able to install additional plugins. </p>
							</div>
						</div>
					`;
					// Show relevant data to the active tab
					showRelevantDataToTab($(this), content);
				} else {
					sessionStorage.setItem('activeTab', 'Plugins');
				}
			} else if($(this).find('.csf-tabbed-active').text() === 'Demo Data'){

				// if(!akd_localization_data.theme_info.requiredPlugins){
				// 	$('.csf-tabbed-active').prev().click();
				// }

				//if theme is not activated then show alert within the Demo Data tab
				if(!akd_localization_data.additional_data.purchaseCode){
					content += `
						<div class="csf-field csf-demo-data">
							<div class="demo-data-container">
								<p> Activate your theme in order to be able to install demo data. </p>
							</div>
						</div>
					`;
					// Show relevant data to the active tab
					showRelevantDataToTab($(this), content);
				} else {
					sessionStorage.setItem('activeTab', 'Demo Data');
				}
			} else if($(this).find('.csf-tabbed-active').text() === 'Theme Setup'){
				//if theme is not activated then show alert within the Theme Setup tab
				if(!akd_localization_data.additional_data.purchaseCode){
					content += `
						<div class="csf-field csf-demo-data">
							<div class="demo-data-container">
								<p> Activate your theme in order to be able to steup your theme. </p>
							</div>
						</div>
					`;
					// Show relevant data to the active tab
					showRelevantDataToTab($(this), content);
				} else {
					sessionStorage.setItem('activeTab', 'Theme Setup');
				}
			} else if($(this).find('.csf-tabbed-active').text() === 'Theme Settings'){
				//if theme is not activated then show alert within the Theme Setup tab
				if(!akd_localization_data.theme_info.elementor){
					content += `
						<div class="csf-field csf-demo-data">
							<div class="demo-data-container">
								<p> Please activate your theme and install required plugins. </p>
							</div>
						</div>
					`;
					// Show relevant data to the active tab
					showRelevantDataToTab($(this), content);
				} else {
					sessionStorage.setItem('activeTab', 'Theme Settings');
					
				}
			} else if($(this).find('.csf-tabbed-active').text() === 'Theme Activation'){
				sessionStorage.setItem('activeTab', 'Theme Activation');
			}
		});
    }

	function changeCodestarActiveItem(){
		const setActiveItem = () => {
			let hash = window.location.hash;
		
			// If no hash in the URL, check sessionStorage for the saved tab
			if (!hash) {
				hash = sessionStorage.getItem('activeItem') || '#tab=dashboard'; // Default to the Dashboard tab
				window.location.hash = hash; // Update the URL with the saved hash
			} else {
				// Save the current hash to sessionStorage if it exists
				sessionStorage.setItem('activeItem', hash);
			}
		
			// Remove the 'csf-tab-expanded' class from all tabs
			document.querySelectorAll(".csf-tab-item").forEach((tab) => {
				tab.classList.remove("csf-tab-expanded");
			});
		
			// Add the 'csf-tab-expanded' class to the tab matching the current hash
			const activeItem = document.querySelector(`.csf-tab-item a[href="${hash}"]`);
			if (activeItem) {
				activeItem.parentElement.classList.add("csf-tab-expanded");
			}
		};
		
		// Run once on page load
		
		const savedItem = sessionStorage.getItem('activeItem');
	
		if (savedItem) {
			// Update the URL hash to the saved item from sessionStorage
			window.location.hash = savedItem;
		}
	
		// Set the active item based on the hash
		setActiveItem();
		
		// Update sessionStorage when the hash changes
		window.addEventListener("hashchange", setActiveItem);
		
		// Update sessionStorage and active tab on click
		document.querySelectorAll(".csf-tab-item a").forEach((link) => {
			link.addEventListener("click", (e) => {
				const hash = e.target.getAttribute("href");
				sessionStorage.setItem('activeItem', hash);
		
				// Manually call the setActiveItem to ensure immediate UI update
				setActiveItem();
			});
		});
	}

	//method to show custom data to the codestar tab
    function showRelevantDataToTab(currentElement, content) {
        // Iterate over each tabbed content div
        currentElement.next().find('.csf-tabbed-content').each(function(index, div) {
            // Check if the div is not hidden
            if (!$(div).hasClass('hidden')) {
                // Set innerHTML of the div to the provided content
                div.innerHTML = content;
            }
        });
    }

	//method to manage minor JS code events
	function minorJsCode(){
		// open demo Importer tab on run importer click
		$(document).on('click', '.akd-run-importer-btn', function(e){
			e.preventDefault();
			if (akd_localization_data.theme_info.requiredPlugins) {
				$('.csf-tabbed-active').next().next().click();
			} else {
				Swal.fire({
					title: "Oops!",
					text: "Install/Activate required plugins first.",
					icon: "error"
				});
			}
		});

		// open Theme settings tab on run importer click
		
		$(document).on('click', '.akd-run-theme-settings-btn', function(e){
			e.preventDefault();
			if(akd_localization_data.theme_info.demoDataImported){
				$('.csf-tabbed-active').next().next().next().next().click();
			}else {
				Swal.fire({
					title: "Oops!",
					text: "Install and Demo Data first.",
					icon: "error"
				});
			}
		});

		//active dashboard when user comes from notices to dashboard
		if (window.location.href.indexOf("akd-framework") > -1) {
			var $navLinks = $('.csf-nav a');
			var hasActiveClass = $navLinks.hasClass('csf-active');

			if (!hasActiveClass) {
				$navLinks.first().get(0).click();
			}

			$('.csf-tabbed-nav')[0].children[3].style.display = 'none';
		}


		//disable pugins and demo data and theme settings tab if the demo is not imported yet and plugins are not installed
		if (!akd_localization_data.theme_info.licenseActivated) {
			// Disable plugin and Demo Data and Theme Settings tabs
			$('.csf-tabbed-nav a:contains("Plugins"), .csf-tabbed-nav a:contains("Demo Data"), .csf-tabbed-nav a:contains("Theme Settings")').each(function() {
				$(this).addClass('disabled-tab').attr('href', 'javascript:void(0);');
			});
		}

		//disable demo data and theme settings tab if the demo is not imported yet and plugins are not installed
		if (!akd_localization_data.theme_info.requiredPlugins) {
			console.log('object');
			// Disable Demo Data and Theme Settings tabs
			$('.csf-tabbed-nav a:contains("Demo Data"), .csf-tabbed-nav a:contains("Theme Settings")').each(function() {
				$(this).addClass('disabled-tab').attr('href', 'javascript:void(0);');
			});
		}

		// Check the condition for elementor
		if (!akd_localization_data.theme_info.demoDataImported) {
			// Disable Theme Settings tab
			$('.csf-tabbed-nav a:contains("Theme Settings")').each(function() {
				$(this).addClass('disabled-tab').attr('href', 'javascript:void(0);');
			});
			$('.csf-tab-item a:contains("WHMCS API Integrations")').each(function() {
				$(this).addClass('disabled-tab').attr('href', 'javascript:void(0);');
			});
			$('#toplevel_page_akd-framework li a:contains("WHMCS API Integrations")').each(function() {
				$(this).addClass('disabled-tab').attr('href', 'javascript:void(0);');
			});
		}
		//if theme is activated then show welcome content on the general tab
		if($('.csf-tabbed-nav').find('.csf-tabbed-active').text() === 'Theme Activation'){
			if(akd_localization_data.additional_data.purchaseCode){
				$('.csf-tabbed-nav').find('.csf-tabbed-active').html('<i class="fa fa-cube"></i> General');
				let content = generalTabContentAfterActivation();
				// Show relevant data to the active tab
				showRelevantDataToTab($('.csf-tabbed-nav'), content);
			} else {
				$('.csf-tabbed-content .akd-general-tab-content').css('display', 'block');
				$('.csf-tabbed-content .akd-full-name').css('display', 'block');
				$('.csf-tabbed-content .akd-email').css('display', 'block');
				$('.csf-tabbed-content .akd-act-option').css('display', 'block');
			}
		}
	

		if (window.location.href.indexOf("akd-framework") > -1 && sessionStorage.getItem('activeTab')) {
			function activateTab() {
				// Retrieve the active tab from sessionStorage
				var activeTab = sessionStorage.getItem('activeTab');

				// Remove the 'csf-tabbed-active' class from all anchor elements
				$('.csf-tabbed-nav a').removeClass('csf-tabbed-active');

				// Initialize a variable to store the index
				var activeTabIndex = -1;

				if (sessionStorage.getItem('activeTab') === 'Install Demo') {
					$('.csf-tabbed-nav')[0].children[3].style.display = 'block';
					$('.csf-tabbed-active').next().click();
					$('.js-merlin-demo-import-select').attr('disabled', true);

					// Show the import section and hide the trigger button
					$('.akd-demo-import').css('display', 'flex');
					// $('.akd-trigger-import').hide();
					$('.akd-demo-import-content').show();

					let layoutNumber = sessionStorage.getItem('layoutNumber');

					if ($('.merlin__select-control.js-merlin-demo-import-select').length <= 0) {
						let content = `
							<select class="merlin__select-control js-merlin-demo-import-select" disabled="disabled">
								<option value="0">Hostiko Layout ${layoutNumber}</option>
							</select>
						`;
						$('.akd-demo-import .merlin__content--transition').append(content);
					} else {
						// Get the dropdown element
						let selectDropdown = $('.merlin__select-control.js-merlin-demo-import-select');

						// Loop through each option to find the one with matching text
						selectDropdown.find('option').each(function(index, option) {
							if ($(option).text().includes(layoutNumber)) {
								// If the option text contains the layout number, set it as selected
								selectDropdown.val($(option).val());
								// Break out of the loop since we found the matching option
								return false;
							}
						});
					}
				}

				// Add the 'csf-tabbed-active' class to the anchor element corresponding to the activeTab
				$('.csf-tabbed-nav a').each(function(index) {
					if ($(this).text().trim() === activeTab) {
						$(this).addClass('csf-tabbed-active');
						activeTabIndex = index; // Set the activeTabIndex
					}
				});

				// Loop through each tab content
				$('.csf-tabbed-content').each(function(index) {
					// If the index matches the activeTabIndex, remove the 'hidden' class
					if (index === activeTabIndex) {
						$(this).removeClass('hidden');
					} else {
						// Otherwise, add the 'hidden' class
						$(this).addClass('hidden');
					}
				});

				// Check if the active tab was found and activated, otherwise call the function again
				if (activeTabIndex === -1) {
					setTimeout(activateTab, 100); // Try again after 100ms
				}
			}

			// Call the function for the first time
			activateTab();
		} else {
			sessionStorage.removeItem('activeTab');
		}

		//all time load plugin listing of merlin framework
		$('body').addClass('merlin__drawer--open');

		//update theme activatation status on the framework
		if($('.csf-options').data('unique') === 'akd-framework-admin-page'){
			$('<p class="akd-theme-status"> Not Activated </p>').insertBefore('.csf-header-left');
			if(akd_localization_data.additional_data.purchaseCode){
				$('[name="akd_theme_purchase_code"]').val(akd_localization_data.additional_data.purchaseCode);
				$('.akd-theme-status').css('background-color', '#0CC2AA');
				$('.akd-theme-status').text('Activated')
			}
		}

		let generalTabIntroContent = `
			<div class="akd-general-tab-content">
				<h2 class="akd-general-into-title">
					Welcome ${akd_localization_data.theme_info.themeName} Customers					
				</h2>
				<div class="akd-general-section-description">
					<p>Get started with Hostiko! To access plugins, demo content, support, and updates, please activate your theme.</p>
				</div>
			</div>
		`;
		$(generalTabIntroContent).insertBefore('.akd-full-name');
		
		

		//proceed to next step
		$(document).on('click', '.akd-cdf-next-step, .akd-after-req-plugin-inst, .akd-req-plugin-next', function(e){
			e.preventDefault();
			$('.csf-tabbed-active').next().click();
		});

		$(document).on('click', '.akd-content-next', function(e){
			e.preventDefault();
			$('.csf-tabbed-active').next().next().click();
		});

		//view site after demo import
		$(document).on('click', '.akd-view-site', function(e){
			e.preventDefault();
			window.open(akd_localization_data.urls_to_frontend.siteUrl, '_blank');
		});
		
		$('.akd-merlin-req-plugins').show();

		$(document).on('click', '.merlin__button--back', function (e){
			e.preventDefault();
			$('.csf-tabbed-active').prev().click();
		});

		$('.akd-demo-import').appendTo('.akd-demo-import-content');
		$('.akd-demo-import-content').hide();
		
		$(document).on('click', '.akd-close-import', function (e){
			e.preventDefault();
			window.location.href = window.location.href;
		});

		//update manual download link
		$(document).on('change', '#layout_select', function(e){
			$('.akd-download-manual-files').attr('href', $(this).val());
		})

		//hide install child theme button if already installed and activated
		if(akd_localization_data.theme_info.childTheme){
			$('.akd-install-child-theme').hide();
		}

		//add merlin class in the body
		$('body').addClass('merlin__body merlin__body--plugins sticky-menu loaded');

		//hide save button for the plugin and demo data screens
		$(document).on('click', '.csf-tabbed-nav', function(){
			if($(this).find('.csf-tabbed-active').text() === 'Plugins'){
				//hide save button as well
				$('.csf-save').hide();
			} else if($(this).find('.csf-tabbed-active').text() === 'Demo Data'){
				$('.csf-save').hide();
			} else {
				$('.csf-save').show();
			}
		});

		//hide theme setup from appearance
		// Find the li element containing "Theme Setup" text and hide it
		$("ul.wp-submenu li").filter(function() {
			return $(this).text() === "Theme Setup";
		}).hide();
	}
	//theme tab content after theme activation
	// function themeSettingTabContent(){
	// 	let content = `
	// 		<div id="tab-content" class="tab">
	// 			<button class="tablinks" onclick="openCity(event, 'London')">London</button>
	// 			<button class="tablinks" onclick="openCity(event, 'Paris')">Paris</button>
	// 			<button class="tablinks" onclick="openCity(event, 'Tokyo')">Tokyo</button>
	// 		</div>

	// 		<div id="London" class="tabcontent">
	// 			<h3>London</h3>
	// 			<p>London is the capital city of England.</p>
	// 		</div>

	// 		<div id="Paris" class="tabcontent">
	// 			<h3>Paris</h3>
	// 			<p>Paris is the capital of France.</p> 
	// 		</div>

	// 		<div id="Tokyo" class="tabcontent">
	// 			<h3>Tokyo</h3>
	// 			<p>Tokyo is the capital of Japan.</p>
	// 		</div>
	// 	`;
	// 	return content;
	// }

	//general tab content after theme activation
	function generalTabContentAfterActivation(){
		let content = `
			<div class="akd-theme-content akd-activated-theme-content">`;

				if(!akd_localization_data.theme_demo){

					if(akd_localization_data.theme_info.installedChildTheme){
						content += `
						<div class="akd-cdf-description">
							<p class="validate-success" style="text-align:center;">The Child Theme is installed and activated. Please click the <span class="akd-text-bold">'Launch Setup'</span> button below.</p>
						</div>`;
					} else {
						content += `
						<div class="akd-cdf-description">
							<p>To protect your customizations from theme updates, we recommend installing a Child Theme. This ensures your CSS and code changes are preserved. If you prefer not to install the Child Theme, you can still proceed by clicking the <span class="akd-text-bold">'Launch Setup'</span> button.</p>
						</div>`;
					}
					
					content += `
						<div class="akd-cdf-buttons">		
							<button class="akd-install-child-theme akd-cdf-button">${akd_localization_data.theme_info.childThemeFound ? 'Activate Child Theme' : 'Create Child Theme'} <i class="fa fa-spinner child-theme-loader loader akd-btn-loader-animation"></i></button>
							<a href="#" class="akd-cdf-next-step akd-cdf-button">Launch Setup</a>
							
						</div>
					`;
				}
				
				content += `<div class="akd-license-section">
					<h2 class="akd-license-section-title customer-support-title">${akd_localization_data.theme_info.themeName.split(' ')[0]} License Details</h2>
					<div class="akd-license-section-description">
						<p class="akd-license-section-info">Each theme license is valid for one primary domain, including all its subdomains. This means you can use the license for multiple subdomains under the same primary domain without needing additional licenses.</p>
						<p class="akd-license-section-note">To switch the license to another domain, click <b>'Disconnect Domain'</b> first, then enter the purchase code on the new WordPress site.</p>
						<p class="akd-license-section-note"><span class="akd-license-domain-label">Note:</span> For more information on licensing policies, please refer to the <a target="_blank" href="https://themeforest.net/licenses/standard"> ThemeForest License Policy</a>.</p>
						<p class="akd-license-section-status">
							<span class="akd-license-domain-label akd-license-section-status-title">Activation Status:</span>
							<span class="akd-license-section-status-label">Activated</span>
						</p>
						<p class="akd-license-domain">
							<span class="akd-license-domain-label">Domain:</span>
							<span class="akd-license-domain-url">${akd_localization_data.urls_to_frontend.siteUrl}</span>
						</p>
					</div>
					<div class="akd-license-btn">
						<a href="#" class="akd-cdf-button akd-disconnect-domain" data-purchase-code="${akd_localization_data.additional_data.purchaseCode ? akd_localization_data.additional_data.purchaseCode : ''}">Disconnect domain</a>
					</div>
				</div>
			</div>
			<div class="akd-help-section-outter">
				<div class="akd-help-block-inner akd-doc-block-outter">
					<div class="akd-doc-img-outter">
						<figure class="akd-doc-img">
							<img class="akd-help-icons akd-doc-icon" src="${akd_localization_data.plugin_path}./images/doc-icon.png">
						</figure>
					</div>
					<div class="akd-doc-desc-outter">
						<h2>Documentation</h2>
						<p>Explore our documentation!</p>
						<div class="akd-help-btn-outter"><a class="akd-doc-button-link" href="https://akdesigner.com/whmcs-templates/index.php?rp=/knowledgebase/" target="_blank">Read Docs</a></div>
					</div>
				</div>
				<div class="akd-help-block-inner akd-live-support-block-outter">
					<div class="akd-live-support-img-outter">
						<figure class="akd-live-support-img">
							<img class="akd-help-icons akd-live-support-icon" src="${akd_localization_data.plugin_path}./images/live-chat-icon.png">
						</figure>
					</div>
					<div class="akd-live-support-desc-outter">
						<h2>Need Live Assistance?</h2>
						<p>Our live support team is here to help!</p>
						<div class="akd-help-btn-outter"><a class="akd-live-support-button-link" href="https://designingmedia.com/help-center" target="_blank">Live Chat</a></div>
					</div>
				</div>
				<div class="akd-help-block-inner akd-demo-block-outter">
					<div class="akd-demo-img-outter">
						<figure class="akd-demo-img">
							<img class="akd-help-icons akd-demo-icon" src="${akd_localization_data.plugin_path}./images/demo-icon.png">
						</figure>
					</div>
					<div class="akd-demo-desc-outter">
						<h2>Our Demos</h2>
						<p>Take a look at our demos here!</p>
						<div class="akd-help-btn-outter"><a class="akd-demo-button-link" href="https://hostiko.com" target="_blank">View Demos</a></div>
					</div>
				</div>
			</div>
			<div class="akd-demo-setup-outter">
				<div class="akd-demo-setup-import-inner import-demo-section">
					<div class="akd-demo-setup-img">
						<figure class="akd-demo-setup-img">
							<img class="akd-demo-setup-icons akd-demo-setup-icon" src="${akd_localization_data.plugin_path}./images/import-demo-img.png">
						</figure>
					</div>
					<div class="akd-demo-setup-content">
						<h2>Import Demo</h2>
						<p>Import demo content to set up your site.</p>
						<a class="akd-demo-setup-btn akd-run-importer-btn" href="#">Run Importer</a>
					</div>
					
				</div>
				<div class="akd-demo-setup-import-inner plugin-demo-section">
					<div class="akd-demo-setup-img">
						<figure class="akd-demo-setup-img">
							<img class="akd-demo-setup-icons akd-demo-setup-icon" src="${akd_localization_data.plugin_path}./images/import-customizer-img.png">
						</figure>
					</div>
					<div class="akd-demo-setup-content">
						<h2>Customizer</h2>
						<p>Customize the theme’s appearence and settings</p>
						<a class="akd-demo-setup-btn akd-run-customizer-btn" href="${akd_localization_data.urls_to_frontend.siteUrl}/wp-admin/customize.php">Run Customizer</a>
					</div>
					
				</div>
				<div class="akd-demo-setup-import-inner customizer-demo-section">
					<div class="akd-demo-setup-img">
						<figure class="akd-demo-setup-img">
							<img class="akd-demo-setup-icons akd-demo-setup-icon" src="${akd_localization_data.plugin_path}./images/theme-settingr-img.png">
						</figure>
					</div>
					<div class="akd-demo-setup-content">
						<h2>Theme Settings</h2>
						<p>Configure theme settings to personalize your website.</p>
						<a class="akd-demo-setup-btn akd-run-theme-settings-btn" href="${akd_localization_data.urls_to_frontend.siteUrl}/wp-admin/admin.php?page=akd-framework#tab=dashboard">Run Theme Settings</a>
					</div>
				</div>
				
			</div>
			<div class="akd-server-info">
				<table class="akd-server-info-table">
					<thead>
						<tr>
							<th>Server Configuration</th>
							<th>Current Configuration</th>
							<th>Suggested Configuration</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td data-tooltip-text="The version of WordPress installed on your site.">WordPress Current Version</td>
							<td style="${akd_localization_data.server_info.wp_version > '6.0' ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.wp_version}</td>
							<td>6.x</td>
						</tr>
						<tr>
							<td data-tooltip-text="The version of PHP installed on your hosting server.">PHP Version</td>
							<td style="${akd_localization_data.server_info.php_v > '8.0' ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.php_v}</td>
							<td>8.x</td>
						</tr>
						<tr>
							<td data-tooltip-text="The directory must be writable to allow demo data upload, plugin and skin updates, etc.">WordPress Writable Permissions</td>
							<td style="${akd_localization_data.server_info.wp_dir_writeable ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.wp_dir_writeable}</td>
							<td>true</td>
						</tr>
						<tr>
							<td data-tooltip-text="The maximum amount of memory (RAM) that your site can use at one time.">PHP Memory Limit</td>
							<td style="${akd_localization_data.server_info.php_memory_limit >= '128M' ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.php_memory_limit}</td>
							<td>128M</td>
						</tr>
						<tr>
							<td data-tooltip-text="The amount of time (in seconds) that your site will spend on a single operation before timing out (to avoid server lockups).">PHP Max Execution Time (sec)</td>
							<td style="${akd_localization_data.server_info.php_max_execution_time >= 300 ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.php_max_execution_time}</td>
							<td>300+</td>
						</tr>
						<tr>
							<td data-tooltip-text="The function takes the content from a file and turns it into text you can use.">File Get Content Permission</td>
							<td style="${(akd_localization_data.server_info.file_get_content = 'Enable') ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.file_get_content}</td>
							<td>Enable</td>
						</tr>
						<tr>
							<td data-tooltip-text="The function takes the content from a file and turns it into text you can use.">Curl Status</td>
							<td style="${(akd_localization_data.server_info.curl_option = 'Enable') ? 'color:#38bb7a' : 'color:red'}">${akd_localization_data.server_info.curl_option}</td>
							<td>Enable</td>
						</tr>
					</tbody>
				</table>
			</div>

		`;
		return content;
	}

	//install child theme
	function installChildTheme(){
		$(document).on('click', '.akd-install-child-theme', function(e){
			e.preventDefault();
			$('.child-theme-loader').show();
			$.ajax({
				type: 'POST',
				url: akd_localization_data.urls_to_frontend.ajaxUrl,
				data: {
					action: 'install_child_theme',
					install: 'install_child',
				},
				success: function(response) {
					$('.child-theme-loader').hide();
					if(response.success === true && response.data != undefined){
						if(response.data.done === 1){
							$('.akd-validate-envato-code').before('<div class="validate-success"> '+response.data.message+' </div>');
							$('.akd-cdf-description').html(`<p class="validate-success" style="text-align:center;">The Child Theme is installed and activated. Please click the <span class="akd-text-bold">'Launch Setup'</span> button below.</p>`);
							$('.akd-install-child-theme').hide();
						}
					}
				},
				error: function(error) {
					return error
				}
			});
		});
	}

	//download manual files
	function downloadThemeFiles(){
		$(document).on('click', '.akd-download-manual-files', function(e){
			e.preventDefault();
			let currentElement = $(this);
			$.ajax({
				type: 'POST',
				url: akd_localization_data.urls_to_frontend.ajaxUrl,
				data: {
					action: 'download_theme_files',
					layout: $(this).attr('href').split('layout-')[1],
				},
				success: function(response) {
					if(response && response.success === true && response.data != undefined){
						window.open(response.data, '_blank');
					} else if(response && response.success === false){
						$('.validate-error').remove();
						currentElement.parent().parent().parent().after('<div class="validate-error"> '+response.data.message+' </div>')
					}
				},
				error: function(error) {
					return error
				}
			});
		});
	}

	function newDemoLayoutTrigger() {
		$(document).on('click', '.akd-new-damo-triger', function(e) {
			e.preventDefault(); // Prevent the default action
			Swal.fire({
				title: "Are you sure you want to reset the site?",
				text: "Demo Layout "+ akd_localization_data.theme_demo +" has already been imported. This will reset your site to default values. All content will be lost.",
				icon: "warning", // Changed from 'type' to 'icon'
				iconColor: "#dd6b55",
				// imageUrl: 'https://demo.designingmedia.com/Hostiko/layout-'+ akd_localization_data.theme_demo +'.png',
				// imageAlt: 'layout-'+ akd_localization_data.theme_demo +'.png',
				// imageWidth: 250,
				showCancelButton: true,
				confirmButtonColor: "#DD6B55",
				confirmButtonText: "Yes, delete it!",
				cancelButtonText: "Cancel",
				closeOnConfirm: false
			}).then((result) => {
				if (result.isConfirmed) {
					$.ajax({
						type: 'POST',
						url: akd_localization_data.urls_to_frontend.ajaxUrl,
						data: {
							action: 'reset_wordpress_and_reactivate',
						},
						success: function(response) {
							if(response.success === true && response.data != undefined){
								console.log("WordPress has been reset.");
								// Handle successful reset (optional UI updates)
								Swal.fire(
									'Reset!',
									'WordPress has been reset successfully.',
									'success'
								).then(() => {
									// Reload the page after clicking "OK"
									location.reload();
								});
							} else {
								Swal.fire(
									'Error!',
									'There was an issue resetting WordPress.',
									'error'
								);
							}
						},
						error: function(error) {
							Swal.fire(
								'Error!',
								'An unexpected error occurred.',
								'error'
							);
						}
					});
				}
			});
		});
	}
	

	//download import files
	function downloadImportFiles(){
		$(document).on('click', '.akd-trigger-import', function(e){
			e.preventDefault();

			if (akd_localization_data.theme_info.requiredPlugins) {
				sessionStorage.setItem('activeTab', 'Install Demo');
				let content = `
					<div class="akd-wrapper">
						<div class="akd-loader-container">
						<div class="akd-loader"></div>
						</div>
					</div>
				`;
				$('.csf-options').append(content);

				let layoutNumber = $(this).data('layout');
				sessionStorage.setItem('layoutNumber', layoutNumber);

				$.ajax({
					type: 'POST',
					url: akd_localization_data.urls_to_frontend.ajaxUrl,
					data: {
						action: 'download_import_files',
						layout: layoutNumber,
					},
					success: function(response) {
						if(response && response.success === true && response.data != undefined){
							window.location.reload();
							// $('.akd-wrapper').remove();
						} else if(response && response.success === false && response.data != undefined){
							Swal.fire({
								title: "Oops!",
								text: response.data.message,
								icon: "error"
							});
							$('.akd-wrapper').remove();
						}
					},
					error: function(error) {
						return error
					}
				});

			} else {
				Swal.fire({
					title: "Oops!",
					text: "Install/Activate required plugins first.",
					icon: "error"
				});
			}
			
		});
	}

	//method to import single theme layout
	function akdImportSingleLayout(){
		$(document).on('click', '.akd-trigger-single-import', function(e){
			e.preventDefault();
			
			if(akd_localization_data.theme_info.requiredPlugins){

				$('.csf-tabbed-nav')[0].children[3].style.display = 'block';
				$('.csf-tabbed-active').next().click();
				$('.js-merlin-demo-import-select').attr('disabled', true);

				let layoutNumber = $(this).data('layout');
			
				// Show the import section and hide the trigger button
				$('.akd-demo-import').css('display','flex');
				// $('.akd-trigger-import').hide();
				$('.akd-demo-import-content').show();

				// Get the dropdown element
				let selectDropdown = $('.merlin__select-control.js-merlin-demo-import-select');
				
				// Loop through each option to find the one with matching text
				selectDropdown.find('option').each(function(index, option) {
					if ($(option).text().includes(layoutNumber)) {
						// If the option text contains the layout number, set it as selected
						selectDropdown.val($(option).val());
						// Break out of the loop since we found the matching option
						return false;
					}
				});
			} else {
				$(this).parent().parent().parent().parent().after('<div class="validate-error"> Plugin Install/Activate required plugins. </div>')
			}
		});
	}

})( jQuery );
