<?php
update_option( '_purchase_code_validate', true );
update_option( '_encryption_key', '********' );
update_option( '_pruchase_code', '********' );
update_option( '_akd_designingmedia_validate', true );

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              https://designingmedia.com/
 * @since             1.0.0
 * @package           Akd_Framework
 *
 * @wordpress-plugin
 * Plugin Name:       AKD Demo Importer
 * Plugin URI:        https://designingmedia.com/
 * Description:       This plugin will help you to import theme's demo content.
 * Version:           1.1.6
 * Author:            Designingmedia
 * Author URI:        https://designingmedia.com//
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       akd-demo-importer
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'AKD_FRAMEWORK_VERSION', '1.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-akd-framework-activator.php
 */
function activate_akd_framework() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-akd-framework-activator.php';
	Akd_Framework_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-akd-framework-deactivator.php
 */
function deactivate_akd_framework() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-akd-framework-deactivator.php';
	Akd_Framework_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_akd_framework' );
register_deactivation_hook( __FILE__, 'deactivate_akd_framework' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-akd-framework.php';

/**
 * Codestar Framework include
 */
require_once plugin_dir_path( __FILE__ ) . 'includes/codestar-framework/classes/setup.class.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_akd_framework() {

	/**
	 * Apply parent and child theme validation
	 */
	if( 'Hostiko' == wp_get_theme()->get('Name') || 'Hostiko Child' == wp_get_theme()->get('Name') ) {
		$plugin = new Akd_Framework();
		$plugin->run();
	}
}
run_akd_framework();



function update_codestar_fields_callback() {
    // Verify user permissions
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Unauthorized']);
    }

    if (!isset($_POST['changed_data']) || empty($_POST['changed_data'])) {
        wp_send_json_error(['message' => 'No changes detected']);
    }

    $changed_data = $_POST['changed_data'];
    $theme = wp_get_theme();
    $theme_slug = $theme->get_stylesheet();
    $akd_theme_mods = get_option('theme_mods_' . $theme_slug, []);

	$fields = [
		'opt-switcher-topbar' => 'hostiko_topbar_switch',
		'opt-switcher-showbutton' => 'hostiko_show_header_btn',
		'login-button-txt' => 'hostiko_header_btn_text',
		'opt-switcher-topbar-bg' => 'hostiko_header_topbar_bg',
		
		'opt-switcher-livechat' => 'hostiko_show_live_chat_btn',
		'opt-livechat-bg' => 'hostiko_live_bg',
		'opt-livechat-color' => 'hostiko_live_color',
		'opt-livechat-border-color' => 'hostiko_live_border',
		'opt-livechat-border-radius' => 'hostiko_live_chat_br',
		'opt-livechat-padding' => 'hostiko_live_chat_padding',
		'opt-livechat-border-hover-color' => 'hostiko_live_border_hover',
		'opt-livechat-bg-hover-color' => 'hostiko_live_bg_hover',
		'opt-livechat-hover-color' => 'hostiko_live_color_hover',
	
		'opt-switcher-carticon' => 'hostiko_show_cart_icon_btn',
		'opt-carticon-bg' => 'hostiko_cart_icon_bg',
		'opt-carticon-color' => 'hostiko_cart_icon_color',
		'opt-carticon-border-color' => 'hostiko_cart_icon_border',
		'opt-carticon-border-radius' => 'hostiko_cart_icon_br',
		'opt-carticon-padding' => 'hostiko_cart_icon_padding',
		'opt-carticon-border-hover-color' => 'hostiko_cart_icon_border_hover',
		'opt-carticon-bg-hover-color' => 'hostiko_cart_icon_bg_hover',
		'opt-carticon-hover-color' => 'hostiko_cart_icon_color_hover',
		'opt-cartcounter-bg-color' => 'hostiko_cart_counter_bg',
		'opt-cartcounter-color' => 'hostiko_cart_counter_color',
		'opt-cartcounter-top' => 'hostiko_cart_counter_top',
		'opt-cartcounter-right' => 'hostiko_cart_counter_right',
	
		'opt-navbar-color' => 'hostiko_nav_color',
		'opt-navbar-hover-color' => 'hostiko_nav_hover_color',
		'opt-navbar-active-color' => 'hostiko_nav_active_color',
		'opt-navbar-dropdown-bg' => 'hostiko_nav_dropdown_bg',
		'opt-navbar-dropdown-hover-bg' => 'hostiko_nav_dropdown_bg_hover',
		'opt-navbar-dropdown-color' => 'hostiko_nav_dropdown_color',
		'opt-navbar-dropdown-hover-color' => 'hostiko_nav_dropdown_hover_color',
		'opt-navbar-dropdown-position' => 'hostiko_navbar_dropdown_position',
		'opt-navbar-dropdown-border-radius' => 'hostiko_navbar_dropdown_br',
		'opt-navbar-dropdown-border-width' => 'hostiko_dropdown_border_width',
		'opt-navbar-dropdown-border-color' => 'hostiko_nav_dropdown_border_color',
		'opt-navbar-dropdown-bg-color-mobile' => 'hostiko_nav_dropdown_bg_mobile',
		'opt-navbar-dropdown-color-mobile' => 'hostiko_nav_dropdown_color_mobile',
		'opt-navbar-dropdown-color-hover-mobile' => 'hostiko_nav_dropdown_color_hover_mobile',
		'opt-navbar-hamburger-color' => 'hostiko_nav_hamburger_color',
		'opt-navbar-dropdown-border-bottom-width' => 'hostiko_nav_border_bottom',
		
		'login-btn-link' => 'hostiko_header_btn_link',
		'opt-switcher-stikyheader' => 'hostiko_sticky_header_btn',
		'opt-select-header-elementor-template' => 'choose_elementor_header',
		'opt-select-footer-elementor-template' => 'choose_elementor_footer',
		'opt-select-footer-style' => 'choose_default_footer',
		'copyright-txt' => 'hostiko_copyright',
		'opt-switcher-subbanner' => 'hostiko_sub_banner_show',
		'opt-switcher-breadcrumb' => 'hostiko_breadcrumb_show',
		'opt-breadcrumb-title-color' => 'page_title_color',
		'opt-subtitle-color' => 'page_subtitle_color',
		'opt-breadcrumb-bg-color' => 'breadcrumb_bg_color',
		'opt-breadcrumb-color' => 'hostiko_breadcrumb_color',
		'opt-breadcrumb-current-page-color' => 'hostiko_breadcrumb_current_page_color',
		'opt-breadcrumb-hover-color' => 'hostiko_breadcrumb_hover_color',
		'opt-breadcrumb-active-color' => 'hostiko_breadcrumb_active_color',
		'opt-breadcrumb-border-radius' => 'hostiko_breadcrumb_br',
		'opt-breadcrumb-border-width' => 'hostiko_breadcrumb_border_width',
		'opt-breadcrumb-border-color' => 'hostiko_breadcrumb_border_color',
		'opt-breadcrumb-padding' => 'hostiko_breadcrumb_padding',
		'opt-subBannerImage' => 'sub-banner-img',
		'opt-subbanner-padding-desktop' => 'hostiko_sub_banner_padding_desk',
		'opt-subbanner-padding-laptop' => 'hostiko_sub_banner_padding_lap',
		'opt-subbanner-padding-tablet' => 'hostiko_sub_banner_padding_tab',
		'opt-subbanner-padding-mobile' => 'hostiko_sub_banner_padding_mobile',
		'opt-blog-page-title' => 'breadcrumb_blog_title',
		'opt-blog-page-subTitle' => 'breadcrumb_blog_title_details',
		'opt-404-title' => 'hostiko_error_404_text',
		'opt-404-not-found-title' => 'hostiko_error_title',
		'opt-404-desc' => 'hostiko_error_desc',
		'opt-404-link-text' => 'hostiko_error_link_text',
		'opt-switcher-preloader' => 'hostiko_preloader_switch',
		'opt-switcher-showinvestment' => 'hostiko_show_investment_offer_link',
		'investment-button-txt' => 'hostiko_header_link_text',
		'investment-btn-link' => 'hostiko_header_link_url',
		'opt-switcher-show-contact-info' => 'hostiko_show_contact_info',
		'email-txt' => 'hostiko_header_email',
		'phone-txt' => 'hostiko_header_phone',
		'opt-switcher-customizer-settings' => 'hostiko_enable_customizer_settings',
		'opt-switcher-socialprofiles' => 'hostiko_show_social_profiles',
		'social-fb-link' => 'hostiko_topbar_fb_url',
		'social-x-link' => 'hostiko_topbar_twitter_url',
		'social-linkedin-link' => 'hostiko_topbar_linkedin_url',
		'social-instagram-link' => 'hostiko_topbar_instagram_url',

		
	];

    foreach ($changed_data as $post_key => $new_value) {
        // Check if this field has a URL structure
        if (strpos($post_key, 'url') !== false) {
            $new_value = isset($new_value['url']) ? $new_value['url'] : '';
        }

        // Only update if the value actually changed
        if (!array_key_exists($fields[$post_key], $akd_theme_mods) || $akd_theme_mods[$fields[$post_key]] !== $new_value) {
			$akd_theme_mods[$fields[$post_key]] = $new_value;
			update_option('theme_mods_' . $theme_slug, $akd_theme_mods);
            set_theme_mod($post_key, $new_value);
        }
    }

    wp_send_json_success(['message' => 'Settings updated successfully!']);
}

// Register AJAX action
add_action('wp_ajax_update_codestar_fields', 'update_codestar_fields_callback');