<?php
/**
 * Merlin WP configuration file.
 *
 * @package   Merlin WP
 * @version   @@pkg.version
 * @link      https://merlinwp.com/
 * @author    Rich Tabor, from ThemeBeans.com & the team at ProteusThemes.com
 * @copyright Copyright (c) 2018, Merlin WP of Inventionn LLC
 * @license   Licensed GPLv3 for Open Source Use
 */

if ( ! class_exists( 'Merlin' ) ) {
	return;
}

/**
 * Set directory locations, text strings, and settings.
 */
$wizard = new Merlin(

	$config = array(
		'directory'            => 'merlin', // Location / directory where Merlin WP is placed in your theme.
		'merlin_url'           => 'merlin', // The wp-admin page slug where Merlin WP loads.
		'parent_slug'          => 'themes.php', // The wp-admin parent page slug for the admin menu item.
		'capability'           => 'manage_options', // The capability required for this menu to be displayed to the user.
		'child_action_btn_url' => 'https://codex.wordpress.org/child_themes', // URL for the 'child-action-link'.
		'dev_mode'             => true, // Enable development mode for testing.
		'license_step'         => true, // EDD license activation step.
		'license_required'     => true, // Require the license activation step.
		'license_help_url'     => '', // URL for the 'license-tooltip'.
		'edd_remote_api_url'   => '', // EDD_Theme_Updater_Admin remote_api_url.
		'edd_item_name'        => '', // EDD_Theme_Updater_Admin item_name.
		'edd_theme_slug'       => '', // EDD_Theme_Updater_Admin item_slug.
		'ready_big_button_url' => '', // Link for the big button on the ready step.
	),
	$strings = array(
		'admin-menu'               => esc_html( 'Theme Setup' ),

		/* translators: 1: Title Tag 2: Theme Name 3: Closing Title Tag */
		'title%s%s%s%s'            => esc_html( '%1$s%2$s Themes &lsaquo; Theme Setup: %3$s%4$s' ),
		'return-to-dashboard'      => esc_html( 'Return to the dashboard'),
		'ignore'                   => esc_html( 'Disable this wizard'),

		'btn-skip'                 => esc_html( 'Skip'),
		'btn-next'                 => esc_html( 'Next'),
		'btn-start'                => esc_html( 'Start'),
		'btn-no'                   => esc_html( 'Cancel'),
		'btn-plugins-install'      => esc_html( 'Install'),
		'btn-child-install'        => esc_html( 'Install'),
		'btn-content-install'      => esc_html( 'Install'),
		'btn-import'               => esc_html( 'Import'),
		'btn-license-activate'     => esc_html( 'Activate'),
		'btn-license-skip'         => esc_html( 'Later'),

		/* translators: Theme Name */
		'license-header%s'         => esc_html( 'Activate %s'),
		/* translators: Theme Name */
		'license-header-success%s' => esc_html( '%s is Activated'),
		/* translators: Theme Name */
		'license%s'                => esc_html( 'Enter your license key to enable remote updates and theme support.'),
		'license-label'            => esc_html( 'License key'),
		'license-success%s'        => esc_html( 'The theme is already registered, so you can go to the next step!'),
		'license-json-success%s'   => esc_html( 'Your theme is activated! Remote updates and theme support are enabled.'),
		'license-tooltip'          => esc_html( 'Need help?'),

		/* translators: Theme Name */
		'welcome-header%s'         => esc_html( 'Welcome to %s'),
		'welcome-header-success%s' => esc_html( 'Hi. Welcome back'),
		'welcome%s'                => esc_html( 'This wizard will set up your theme, install plugins, and import content. It is optional & should take only a few minutes.'),
		'welcome-success%s'        => esc_html( 'You may have already run this theme setup wizard. If you would like to proceed anyway, click on the "Start" button below.'),

		'child-header'             => esc_html( 'Install Child Theme'),
		'child-header-success'     => esc_html( 'You\'re good to go!'),
		'child'                    => esc_html( 'Let\'s build & activate a child theme so you may easily make theme changes.'),
		'child-success%s'          => esc_html( 'Your child theme has already been installed and is now activated, if it wasn\'t already.'),
		'child-action-link'        => esc_html( 'Learn about child themes'),
		'child-json-success%s'     => esc_html( 'Awesome. Your child theme has already been installed and is now activated.'),
		'child-json-already%s'     => esc_html( 'Awesome. Your child theme has been created and is now activated.'),

		'plugins-header'           => esc_html( 'Install Plugins'),
		'plugins-header-success'   => esc_html( 'You\'re up to speed!'),
		'plugins'                  => esc_html( 'Let\'s install some essential WordPress plugins to get your site up to speed.'),
		'plugins-success%s'        => esc_html( 'The required WordPress plugins are all installed and up to date. Press "Next" to continue the setup wizard.'),
		'plugins-action-link'      => esc_html( 'Advanced'),

		'import-header'            => esc_html( 'Import Content'),
		'import'                   => esc_html( 'Let\'s import content to your website, to help you get familiar with the theme.'),
		'import-action-link'       => esc_html( 'Advanced'),

		'ready-header'             => esc_html( 'All done. Have fun!'),

		/* translators: Theme Author */
		'ready%s'                  => esc_html( 'Your theme has been all set up. Enjoy your new theme by %s.'),
		'ready-action-link'        => esc_html( 'Extras'),
		'ready-big-button'         => esc_html( 'View your website'),
		'ready-link-1'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://wordpress.org/support/', esc_html( 'Explore WordPress') ),
		'ready-link-2'             => sprintf( '<a href="%1$s" target="_blank">%2$s</a>', 'https://designingmedia.com/support/', esc_html( 'Get Theme Support') ),
		'ready-link-3'             => sprintf( '<a href="%1$s">%2$s</a>', admin_url( 'customize.php' ), esc_html( 'Start Customizing') ),
	)
);
