<?php
/**
 * The template to display Admin notices
 *
 * @package WordPress
 * @subpackage hostiko
 * @since hostiko 
 */
 

if (!function_exists('hostiko_get_value_gp')) {
	function hostiko_get_value_gp($name, $defa='') {
		if (isset($_GET[$name]))		$rez = wp_unslash($_GET[$name]);
		else if (isset($_POST[$name]))	$rez = wp_unslash($_POST[$name]);
		else							$rez = $defa;
		return $rez;	//legrand_stripslashes($rez) was changed on wp_uinslash();
	}
}
$hostiko_theme_obj = wp_get_theme();
?>
<div class="update-nag" id="hostiko_admin_notice">
	<h3 class="hostiko_notice_title"><?php
		// Translators: Add theme name and version to the 'Welcome' message
		echo esc_html(sprintf(__('Welcome to %1$s v.%2$s', 'hostiko'),
				$hostiko_theme_obj->name . (hostiko_THEME_FREE ? ' ' . __('Free', 'hostiko') : ''),
				$hostiko_theme_obj->version
				));
	?></h3>
	<p>
		<a href="<?php echo esc_url(admin_url().'themes.php?page=hostiko_about'); ?>" class="button button-primary"><i class="dashicons dashicons-nametag"></i> <?php
			// Translators: Add theme name
			echo esc_html(sprintf(__('About %s', 'hostiko'), $hostiko_theme_obj->name));
		?></a>
		<?php
		if (hostiko_get_value_gp('page')!='tgmpa-install-plugins') {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=tgmpa-install-plugins'); ?>" class="button button-primary"><i class="dashicons dashicons-admin-plugins"></i> <?php esc_html_e('Install plugins', 'hostiko'); ?></a>
			<?php
		}
		if (function_exists('hostiko_exists_trx_addons') && hostiko_exists_trx_addons() && class_exists('trx_addons_demo_data_importer')) {
			?>
			<a href="<?php echo esc_url(admin_url().'themes.php?page=trx_importer'); ?>" class="button button-primary"><i class="dashicons dashicons-download"></i> <?php esc_html_e('One Click Demo Data', 'hostiko'); ?></a>
			<?php
		}
		?>
        <a href="<?php echo esc_url(admin_url().'customize.php'); ?>" class="button button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Customizer', 'hostiko'); ?></a>
		<span> <?php esc_html_e('or', 'hostiko'); ?> </span>
        <a href="<?php echo esc_url(admin_url().'themes.php?page=theme_options'); ?>" class="button button-primary"><i class="dashicons dashicons-admin-appearance"></i> <?php esc_html_e('Theme Options', 'hostiko'); ?></a>
        <a href="#" class="button hostiko_hide_notice"><i class="dashicons dashicons-dismiss"></i> <?php esc_html_e('Hide Notice', 'hostiko'); ?></a>
	</p>
</div>