<?php
/**
 * The template for displaying the footer
 *
 * @category WordPress
 * @package  Hostiko
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://developer.wordpress.org/themes/basics/template-files/#template-partials
 */

$hostiko_redux_option = get_option('opt_theme_options');

// Define a safe default footer
$hostiko_footer = !empty($hostiko_redux_option['footerstyle']) ? sanitize_text_field($hostiko_redux_option['footerstyle']) : 'default';

// Load the footer layout
if (empty($hostiko_redux_option['constructionPage']) || is_user_logged_in()) {
    // Validate and sanitize the 'footer' request parameter to prevent LFI
    if (isset($_REQUEST['footer'])) {
        $allowed_footers = [
            'default', 'hostiko', 'hostiko2', 'hostiko3', 'hostiko4', 'hostiko5', 'hostiko6',
            'hostiko7', 'hostiko8', 'hostiko9', 'hostiko10', 'hostiko11', 'hostiko12', 'hostiko13',
            'hostiko14', 'hostiko15', 'hostiko16', 'hostiko17', 'hostiko18', 'hostiko19', 'hostiko20',
            'hostiko21', 'hostiko22', 'hostiko23', 'hostiko24', 'hostiko25', 'hostiko26', 'hostiko27',
            'hostiko28', 'hostiko29', 'hostiko30', 'custom'
        ];
        $requested_footer = sanitize_text_field($_REQUEST['footer']);

        if (in_array($requested_footer, $allowed_footers, true)) {
            $hostiko_footer = $requested_footer;
        }
    }

    hostikoLayoutfooter($hostiko_footer);
    ?>
    </div>
    <div id="hostiko-footer">
        <?php if (is_array($hostiko_redux_option) && ($hostiko_redux_option['backtotop'] == '1')) {
            if ($hostiko_redux_option['imageortext'] == '1') {
                ?>
                <a href="#top" class="go-top"
                   title="Go to the top of the page"><?php echo esc_html($hostiko_redux_option['texttop']); ?></a>
            <?php } else { ?>
                <a href="#top" class="go-top"
                   title="Go to the top of the page"></a>
            <?php }
        }
        get_template_part('layouts/footer/footer-' . esc_attr($hostiko_footer) . '/footer-' . esc_attr($hostiko_footer), get_post_format());
        ?>
    </div>
    <!-- #hostiko-footer -->
    </div>
    <!-- #page -->
    <?php
}

wp_footer();
?>
</body>
</html>
