<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @category WordPress
 * @package  Hostiko
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://developer.wordpress.org/themes/basics/template-files/#template-partials
 */
$hostiko_redux_option = get_option('opt_theme_options');

// Allowed headers (to prevent LFI)
$allowed_headers = [
    'default', 'hostiko', 'hostiko2', 'hostiko3', 'hostiko4', 'hostiko5', 'hostiko6',
    'hostiko7', 'hostiko8', 'hostiko9', 'hostiko10', 'hostiko11', 'hostiko12', 'hostiko13',
    'hostiko14', 'hostiko15', 'hostiko16', 'hostiko17', 'hostiko18', 'hostiko19', 'hostiko20',
    'hostiko21', 'hostiko22', 'hostiko23', 'hostiko24', 'hostiko25', 'hostiko26', 'hostiko27',
    'hostiko28', 'hostiko29', 'hostiko30', 'custom'
];

// Get header style from theme options or set default
$hostiko_header = !empty($hostiko_redux_option['headerstyle']) ? sanitize_text_field($hostiko_redux_option['headerstyle']) : 'default';

// Check if 'header' is passed in the request and validate it
if (isset($_REQUEST['header'])) {
    $requested_header = sanitize_text_field($_REQUEST['header']);

    if (in_array($requested_header, $allowed_headers, true)) {
        $hostiko_header = $requested_header;
    }
}
?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="<?php bloginfo('charset'); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="profile" href="http://gmpg.org/xfn/11">
    <?php
    wp_head();?>
</head>
<?php
/**
 * CSS include of header as per Redux
 **/
hostikoLayoutHeader($hostiko_header);
Hostiko_Template_css();
?>
<body <?php body_class(); ?>>
