<?php
/**
 * Hostiko Theme Customizer
 * 
 * @category WordPress
 * @package  Hostiko
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://yourwebsite.com
 */

/**
 * Add postMessage support for site title and description for the Theme Customizer.
 *
 * @param WP_Customize_Manager $wp_customize Theme Customizer object.
 * 
 * @return void
 */
function Hostiko_Customize_register($wp_customize) 
{
    $wp_customize->get_setting('blogname')->transport         = 'postMessage';
    $wp_customize->get_setting('blogdescription')->transport  = 'postMessage';
    $wp_customize->get_setting('header_textcolor')->transport = 'postMessage';
    
    if (isset($wp_customize->selective_refresh)) {
        $wp_customize->selective_refresh->add_partial(
            'blogname', 
            array(
                'selector'        => '.site-title a',
                'render_callback' => 'Hostiko_Customize_Partial_blogname',
            )
        );
        $wp_customize->selective_refresh->add_partial(
            'blogdescription', 
            array(
                'selector'        => '.site-description',
                'render_callback' => 'Hostiko_Customize_Partial_blogdescription',
            )
        );
    }
}
add_action('customize_register', 'Hostiko_Customize_register');

/**
 * Render the site title for the selective refresh partial.
 *
 * @return void
 */
function Hostiko_Customize_Partial_blogname() 
{
    bloginfo('name');
}

/**
 * Render the site tagline for the selective refresh partial.
 *
 * @return void
 */
function Hostiko_Customize_Partial_blogdescription() 
{
    bloginfo('description');
}

/**
 * Binds JS handlers to make Theme Customizer preview reload changes asynchronously.
 * 
 * @return void
 */
function Hostiko_Customize_Preview_js() 
{
    wp_enqueue_script('hostiko-customizer', get_template_directory_uri() . '/js/customizer.js', array('customize-preview'), '20151215', true);
}
add_action('customize_preview_init', 'Hostiko_Customize_Preview_js');
