<?php
/**
 * Template part for displaying page content in page.php
 *
 * @category WordPress
 * @package  Hostiko
 * @author   Your Name <your.email@example.com>
 * @license  http://opensource.org/licenses/gpl-2.0.php GPL v2 or later
 * @link     https://codex.wordpress.org/Template_Hierarchy
 */
?>
<article id="post-<?php the_ID(); ?>" class="vc-page">
    <div class="entry-content-vc">
        <?php
        the_content();
        wp_link_pages( 
            array(
                'before' => '<div class="page-links">' . esc_html__('Pages:', 'hostiko'),
                'after'  => '</div>',
            ) 
        );
        ?>
    </div><!-- .entry-content -->
    <?php if (get_edit_post_link()) : ?>
        <footer class="entry-footer-vc">
            <?php
            edit_post_link(
                sprintf(
                    wp_kses(
                    /* translators: %s: Name of current post. Only visible to screen readers */
                        __('Edit <span class="screen-reader-text">%s</span>', 'hostiko'),
                        array(
                            'span' => array(
                                'class' => array(),
                            ),
                        )
                    ),
                    get_the_title()
                ),
                '<span class="edit-link">',
                '</span>'
            );
            ?>
        </footer><!-- .entry-footer -->
    <?php endif; ?>
</article><!-- #post-<?php the_ID(); ?> -->
