<?php
/**
 * The template for displaying the footer
 *
 * Contains the closing of the #content div and all content after.
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package hostiko
 */
?>
<?php 
    $akd_theme_admin_page = get_option( 'akd-framework-admin-page' );
    $elementor_document = \Elementor\Plugin::$instance->documents->get( get_the_ID() );
    $hostiko_default_footer_type = $akd_theme_admin_page['opt-select-default-footer'];
    $hostiko_footer_e = get_theme_mod('choose_elementor_footer');
    $hostiko_footer_type = get_theme_mod('footer_source_type');
    if( $hostiko_default_footer_type != "default-footer"){
        // Default footer
        $page_footer = $hostiko_footer_e;

        if ( $elementor_document instanceof \Elementor\Core\DocumentTypes\Page ) {
            $page_settings = $elementor_document->get_settings();
            
            if ( isset( $page_settings['page_footer_display'], $page_settings['choose_elementor_page_footer'] ) ) {
                $show_page_footer = $page_settings['page_footer_display'];
                $page_footer = $page_settings['choose_elementor_page_footer'];
            }
            // Display footer based on Elementor settings or default footer
            if ( $show_page_footer && in_array( 'elementor/elementor.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {
                    echo Elementor\Plugin::instance() -> frontend -> get_builder_content_for_display($page_footer); 
            }
            else{
                echo Elementor\Plugin::instance() -> frontend -> get_builder_content_for_display($hostiko_footer_e); 
                }
        }else{
            echo Elementor\Plugin::instance() -> frontend -> get_builder_content_for_display($hostiko_footer_e);
        }
    }else{
        do_action('hostiko_footer_style');
    }
    ?>

</div><!-- #page -->

<?php 
wp_footer(); 
    ?>
</body>

</html>