<?php
/** 
 * Hostiko Customizer data
 */

function hostiko_customizer( $data ) {
	$hostiko_elementor_template_list = hostiko_get_elementor_templates();
	$hostiko_elementor_header_templates = hostiko_get_elementor_header_templates();
	$hostiko_elementor_template_list = array(
		'' => esc_html__( 'Select a template', 'hostiko' ) // Empty choice
	) + $hostiko_elementor_template_list;
	return array(
		'panel' => array ( 
			'id' => 'hostiko',
			'name' => esc_html__('Hostiko Customizer','hostiko'),
			'priority' => 10,
			'section' => array(
				// 'hostiko_customizer_settings' => array(
				// 	'name' => esc_html__( 'Hostiko Customizer Settings', 'hostiko' ),
				// 	'priority' => 15,
				// 	'fields' => array(
				// 		array(
				// 			'name' => esc_html__( 'Enable Customizer Settings', 'hostiko' ),
				// 			'id' => 'hostiko_enable_customizer_settings',
				// 			'default' => 1,
				// 			'type' => 'switch',
				// 			'transport'	=> 'refresh' 
				// 		),
				// 	) 
				// ),
				'header_setting' => array(
					'name' => esc_html__( 'Header Topbar Setting', 'hostiko' ),
					'priority' => 10,
					'fields' => array(
						array(
							'name' => esc_html__( 'Topbar Swicher', 'hostiko' ),
							'id' => 'hostiko_topbar_switch',
							'default' => false,
							'type' => 'switch',
							'transport'	=> 'refresh'
						),						
						array(
							'name' => esc_html__( 'Show Button', 'hostiko' ),
							'id' => 'hostiko_show_header_btn',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Topbar Background','hostiko'),
							'id'=>'hostiko_header_topbar_bg',
							'default'=> esc_html__('#f4f9fc','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Button Text', 'hostiko' ),
							'id' => 'hostiko_header_btn_text',
							'default' => esc_html__('Sign in','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Button Link', 'hostiko' ),
							'id' => 'hostiko_header_btn_link',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Button Icon', 'hostiko' ),
							'id' => 'hostiko_header_btn_icon',
							'default' => esc_html__('fa fa-user-o', 'hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** investment button **/	
						array(
							'name' => esc_html__( 'Show Investment Offer Link', 'hostiko' ),
							'id' => 'hostiko_show_investment_offer_link',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Text', 'hostiko' ),
							'id' => 'hostiko_header_link_text',
							'default' => esc_html__('Hostiko Offer','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Link Url', 'hostiko' ),
							'id' => 'hostiko_header_link_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						/** contact-info **/
						array(
							'name' => esc_html__( 'Show Contact Info', 'hostiko' ),
							'id' => 'hostiko_show_contact_info',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Email Address', 'hostiko' ),
							'id' => 'hostiko_header_email',
							'default' => esc_html__('info@gmail.com','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Phone Number', 'hostiko' ),
							'id' => 'hostiko_header_phone',
							'default' => esc_html__('+97657945737', 'hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						)

					) 
				),
				'hostiko_topbar_social_profiles_setting' => array(
					'name' => esc_html__( 'Header Social Profiles', 'hostiko' ),
					'priority' => 15,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Social Profiles', 'hostiko' ),
							'id' => 'hostiko_show_social_profiles',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Facebook Url', 'hostiko' ),
							'id' => 'hostiko_topbar_fb_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'X Url', 'hostiko' ),
							'id' => 'hostiko_topbar_twitter_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Linkedin Url', 'hostiko' ),
							'id' => 'hostiko_topbar_linkedin_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Instagram Url', 'hostiko' ),
							'id' => 'hostiko_topbar_instagram_url',
							'default' => '#',
							'type' => 'text',
							'transport'	=> 'refresh' 
						),
					) 
				),
				'header_main_setting' => array(
					'name' => esc_html__( 'Header Setting', 'hostiko' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Header Elementor Templates', 'hostiko' ),
							'id' => 'choose_elementor_header',
							'type'     => 'select',
							'choices'  => $hostiko_elementor_template_list,
							'transport'	=> 'refresh',
							'required' => ['header_source_type',
							'=',
							'e'],
						),
						array(
							'name' => esc_html__( 'Header Logo', 'hostiko' ),
							'id' => 'logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Black Logo', 'hostiko' ),
							'id' => 'seconday_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Logo', 'hostiko' ),
							'id' => 'retina_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Header Retina Black Logo', 'hostiko' ),
							'id' => 'retina_secondary_logo',
							'default' => get_template_directory_uri() . '/assets/img/logo/logo-black@2x.png',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Margin Bottom', 'hostiko' ),
							'id' => 'hostiko_header_margin_bottom',
							'type' => 'text', // Single text input
							'default' => '', // Default padding value
							'description' => esc_html__( 'Enter margin in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						
						array(
							'name' => esc_html__( 'Margin Bottom Mobile', 'hostiko' ),
							'id' => 'hostiko_header_margin_bottom_mobile',
							'type' => 'text', // Single text input
							'default' => '', // Default padding value
							'description' => esc_html__( 'Enter margin in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Sticky header', 'hostiko' ),
							'id' => 'hostiko_sticky_header_btn',
							'default' => 0,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Stickyheader Background Color','hostiko'),
							'id'=>'hostiko_stickyheader_bg',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Header Color','hostiko'),
							'id'=>'hostiko_header_bg',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Header Width', 'hostiko' ),
							'id' => 'hostiko_header_width',
							'type' => 'text', // Single text input
							'default' => '1140px', // Default padding value
							'description' => esc_html__( 'Header Width: (e.g., 1140x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						
						// array(
						// 	'name' => esc_html__( 'Show Header Search', 'hostiko' ),
						// 	'id' => 'hostiko_header_search_show',
						// 	'default' => 1,
						// 	'type' => 'switch',
						// 	'transport'	=> 'refresh' 
						// ),	
					) 
				),	
				'banner_main_setting' => array(
					'name' => esc_html__( 'Sub Banner Setting', 'hostiko' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Sub Banner', 'hostiko' ),
							'id' => 'hostiko_sub_banner_show',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Banner Image', 'hostiko' ),
							'id' => 'sub-banner-img',
							'default' => get_template_directory_uri() . '/assets/img/sub-banner-img.jpg',
							'type' => 'image',
							'transport'	=> 'refresh',
							
						),
						array(
							'name' => esc_html__( 'Padding Desktop', 'hostiko' ),
							'id' => 'hostiko_sub_banner_padding_desk',
							'type' => 'text', // Single text input
							'default' => '70px 0 70px', // Default padding value
							'description' => esc_html__( 'Enter margin in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Padding Laptop', 'hostiko' ),
							'id' => 'hostiko_sub_banner_padding_lap',
							'type' => 'text', // Single text input
							'default' => '70px 0 70px', // Default padding value
							'description' => esc_html__( 'Enter margin in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Padding Tablet', 'hostiko' ),
							'id' => 'hostiko_sub_banner_padding_tab',
							'type' => 'text', // Single text input
							'default' => '70px 0 70px', // Default padding value
							'description' => esc_html__( 'Enter margin in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Padding Mobile', 'hostiko' ),
							'id' => 'hostiko_sub_banner_padding_mobile',
							'type' => 'text', // Single text input
							'default' => '190px 0 60px', // Default padding value
							'description' => esc_html__( 'Enter margin in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
					) 
				),	
				'page_title_setting'=> array(
					'name'=> esc_html__('Page Title Setting','hostiko'),
					'priority'=> 30,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Breadcrumb', 'hostiko' ),
							'id' => 'hostiko_breadcrumb_show',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						// array(
						// 	'name' => esc_html__( 'Choose Breadcrumb Style', 'hostiko' ),
						// 	'id' => 'choose_default_breadcrumb',
						// 	'type'     => 'select',
						// 	'choices'  => array(
						// 		'breadcrumb-style-1' => esc_html__( 'Breadcrumb Style 1', 'hostiko' ),
						// 		'breadcrumb-style-2' => esc_html__( 'default', 'hostiko' ),
						// 	),
						// 	'default' => 'breadcrumb-style-1',
						// 	'transport'	=> 'refresh'
						// ),
						array(
							'name'=>esc_html__('Title Color','hostiko'),
							'id'=>'page_title_color',
							'default'=> esc_html__('#000','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Subtitle Color','hostiko'),
							'id'=>'page_subtitle_color',
							'default'=> esc_html__('#000','hostiko'),
							'transport'	=> 'refresh'  
						),

						array(
							'name'=>esc_html__('Breadcrumb BG Color','hostiko'),
							'id'=>'breadcrumb_bg_color',
							'default'=> esc_html__('#343a40','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Breadcrumb Color','hostiko'),
							'id'=>'hostiko_breadcrumb_color',
							'default'=> esc_html__('#343a40','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Breadcrumb Current Page Color','hostiko'),
							'id'=>'hostiko_breadcrumb_current_page_color',
							'default'=> esc_html__('#343a40','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Breadcrumb Hover Color','hostiko'),
							'id'=>'hostiko_breadcrumb_hover_color',
							'default'=> esc_html__('#343a40','hostiko'),
							'transport'	=> 'refresh'  
						),
						// array(
						// 	'name'=>esc_html__('Breadcrumb Active Color','hostiko'),
						// 	'id'=>'hostiko_breadcrumb_active_color',
						// 	'default'=> esc_html__('#343a40','hostiko'),
						// 	'transport'	=> 'refresh'  
						// ),
						array(
							'name' => esc_html__( 'Breadcrumb Border Radius', 'hostiko' ),
							'id' => 'hostiko_breadcrumb_br',
							'type' => 'text', // Single text input
							'default' => '4px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Breadcrumb Border width', 'hostiko' ),
							'id' => 'hostiko_breadcrumb_border_width',
							'type' => 'text', // Single text input
							'default' => '4px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name'=>esc_html__('Btreadcrumb Border Color','hostiko'),
							'id'=>'hostiko_breadcrumb_border_color',
							'default'=> esc_html__('#f4f9fc','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Breadcrumb Padding', 'hostiko' ),
							'id' => 'hostiko_breadcrumb_padding',
							'type' => 'text', // Single text input
							'default' => '12px 20px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 12px 20px)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						// array(
						// 	'name' => esc_html__( 'Page Title Background Image', 'hostiko' ),
						// 	'id' => 'breadcrumb_bg_img',
						// 	'default' => '',
						// 	'type' => 'image',
						// 	'transport'	=> 'refresh' 
						// ),	
						// array(
						// 	'name' => esc_html__( 'Breadcrumb Archive', 'hostiko' ),
						// 	'id' => 'breadcrumb_archive',
						// 	'default' => esc_html__('Archive for category','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),	
						// array(
						// 	'name' => esc_html__( 'Breadcrumb Search', 'hostiko' ),
						// 	'id' => 'breadcrumb_search',
						// 	'default' => esc_html__('Search results for','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),	
						// array(
						// 	'name' => esc_html__( 'Breadcrumb tagged', 'hostiko' ),
						// 	'id' => 'breadcrumb_post_tags',
						// 	'default' => esc_html__('Posts tagged','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),		
						// array(
						// 	'name' => esc_html__( 'Breadcrumb posted by', 'hostiko' ),
						// 	'id' => 'breadcrumb_artitle_post_by',
						// 	'default' => esc_html__('Articles posted by','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),		
						// array(
						// 	'name' => esc_html__( 'Breadcrumb Page Not Found', 'hostiko' ),
						// 	'id' => 'breadcrumb_404',
						// 	'default' => esc_html__('Page Not Found','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),		
						// array(
						// 	'name' => esc_html__( 'Breadcrumb Page', 'hostiko' ),
						// 	'id' => 'breadcrumb_page',
						// 	'default' => esc_html__('Page','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),			
						// array(
						// 	'name' => esc_html__( 'Breadcrumb Shop', 'hostiko' ),
						// 	'id' => 'breadcrumb_shop',
						// 	'default' => esc_html__('Shop','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),			
						// array(
						// 	'name' => esc_html__( 'Breadcrumb Home', 'hostiko' ),
						// 	'id' => 'breadcrumb_home',
						// 	'default' => esc_html__('Home','hostiko'),
						// 	'type' => 'text',
						// 	'transport'	=> 'refresh' 
						// ),					
					)
				),
				'blog_setting'=> array(
					'name'=> esc_html__('Blog Setting','hostiko'),
					'priority'=> 40,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Show Blog BTN', 'hostiko' ),
							'id' => 'hostiko_blog_btn_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name' => esc_html__( 'Show Blog Btn Icon', 'hostiko' ),
							'id' => 'hostiko_blog_btn_icon_switch',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),
						array(
							'name' => esc_html__( 'Blog Button text', 'hostiko' ),
							'id' => 'hostiko_blog_btn',
							'default' => esc_html__('Read More','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),							
						array(
							'name' => esc_html__( 'Blog Button Icon', 'hostiko' ),
							'id' => 'hostiko_blog_btn_icon',
							'default' => esc_html__('fas fa-angle-double-right','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Title', 'hostiko' ),
							'id' => 'breadcrumb_blog_title',
							'default' => esc_html__('Blog','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),						
						array(
							'name' => esc_html__( 'Blog Details Title', 'hostiko' ),
							'id' => 'breadcrumb_blog_title_details',
							'default' => esc_html__('Read latest news from our blog & learn new things','hostiko'),
							'type' => 'text',
							'transport'	=> 'refresh' 
						),

					)
				),
				'hostiko_footer_setting' => array(
					'name'=> esc_html__('Footer Setting','hostiko'),
					'priority'=> 60,
					'fields'=> array(
						array(
							'name' => esc_html__( 'Footer Elementor Templates', 'hostiko' ),
							'id' => 'choose_elementor_footer',
							'type'     => 'select',
							'choices'  => $hostiko_elementor_template_list,
							'transport'	=> 'refresh',
							'required' => ['footer_source_type',
							'=',
							'e'],
						),
						// array(
						// 	'name' => esc_html__( 'Choose Footer Style', 'hostiko' ),
						// 	'id' => 'choose_default_footer',
						// 	'type'     => 'select',
						// 	'choices'  => array(
						// 		'footer-style-1' => esc_html__( 'Footer Style 1', 'hostiko' ),
						// 		'footer-style-2' => esc_html__( 'Footer Style 2', 'hostiko' ),
						// 		'footer-style-3' => esc_html__( 'Footer Style 3', 'hostiko' ),
						// 	),
						// 	'default' => 'footer-style-1',
						// 	'transport'	=> 'refresh'
						// ),
						array(
							'name' => esc_html__( 'Footer Background Image', 'hostiko' ),
							'id' => 'hostiko_footer_bg',
							'default' => '',
							'type' => 'image',
							'transport'	=> 'refresh' 
						),
						array(
							'name'=>esc_html__('Footer BG Color','hostiko'),
							'id'=>'hostiko_footer_bg_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Copyright Text','hostiko'),
							'id'=>'hostiko_copyright',
							'default'=> esc_html__('Copyright &copy; Hostiko 2024. All rights reserved','hostiko'),
							'type'=>'text',
							'transport'	=> 'refresh',
						),	
						array(
							'name'=>esc_html__('Enable Scrollup','hostiko'),
							'id'=>'hostiko_scrollup_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),						
						array(
							'name'=>esc_html__('Enable Footer Widgets','hostiko'),
							'id'=>'hostiko_enable_footer_widgets',
							'default'=> true,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						),	
						array(
							'name'=>esc_html__('Enable Preloader','hostiko'),
							'id'=>'hostiko_preloader_switch',
							'default'=> false,
							'type'=>'switch',
							'transport'	=> 'refresh'  
						)
					)
				),
				'error_page_setting'=> array(
					'name'=> esc_html__('404 Setting','hostiko'),
					'priority'=> 90,
					'fields'=> array(
						array(
							'name'=>esc_html__('400 Text','hostiko'),
							'id'=>'hostiko_error_404_text',
							'default'=> esc_html__('404','hostiko'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Not Found Title','hostiko'),
							'id'=>'hostiko_error_title',
							'default'=> esc_html__('Page not found','hostiko'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Description Text','hostiko'),
							'id'=>'hostiko_error_desc',
							'default'=> esc_html__('Oops! The page you are looking for does not exist. It might have been moved or deleted','hostiko'),
							'type'=>'textarea',
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('404 Link Text','hostiko'),
							'id'=>'hostiko_error_link_text',
							'default'=> esc_html__('Back To Home','hostiko'),
							'type'=>'text',
							'transport'	=> 'refresh'  
						)
					)
				),

				// Navbar Style
				'hostiko_navbar_setting' => array(
					'name' => esc_html__( 'Navbar Style', 'hostiko' ),
					'priority' => 20,
					'fields' => array(
						
						
						array(
							'name'=>esc_html__('Color','hostiko'),
							'id'=>'hostiko_nav_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						
						array(
							'name'=>esc_html__('Hover Color','hostiko'),
							'id'=>'hostiko_nav_hover_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Active Color','hostiko'),
							'id'=>'hostiko_nav_active_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						
						array(
							'name'=>esc_html__('Dropdown Background Color','hostiko'),
							'id'=>'hostiko_nav_dropdown_bg',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Dropdown Hover background','hostiko'),
							'id'=>'hostiko_nav_dropdown_bg_hover',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Dropdown Color','hostiko'),
							'id'=>'hostiko_nav_dropdown_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Dropdown Hover Color','hostiko'),
							'id'=>'hostiko_nav_dropdown_hover_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Dropdown Position', 'hostiko' ),
							'id' => 'hostiko_navbar_dropdown_position',
							'type' => 'text', // Single text input
							'default' => '30px', // Default padding value
							'description' => esc_html__( 'Enter border Position in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Dropdown Border Radius', 'hostiko' ),
							'id' => 'hostiko_navbar_dropdown_br',
							'type' => 'text', // Single text input
							'default' => '4px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Border width', 'hostiko' ),
							'id' => 'hostiko_dropdown_border_width',
							'type' => 'text', // Single text input
							'default' => '4px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name'=>esc_html__('Dropdown Border Color','hostiko'),
							'id'=>'hostiko_nav_dropdown_border_color',
							'default'=> esc_html__('#f4f9fc','hostiko'),
							'transport'	=> 'refresh'  
						),

						array(
							'name'=>esc_html__('Dropdown Backgound Color Mobile','hostiko'),
							'id'=>'hostiko_nav_dropdown_bg_mobile',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),

						array(
							'name'=>esc_html__('Dropdown Color Mobile','hostiko'),
							'id'=>'hostiko_nav_dropdown_color_mobile',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),

						array(
							'name'=>esc_html__('Dropdown Color Hover Mobile','hostiko'),
							'id'=>'hostiko_nav_dropdown_color_hover_mobile',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						
						array(
							'name'=>esc_html__('Hamburger Color','hostiko'),
							'id'=>'hostiko_nav_hamburger_color',
							'default'=> esc_html__('#000','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Border Bottom Width', 'hostiko' ),
							'id' => 'hostiko_nav_border_bottom',
							'type' => 'text', // Single text input
							'default' => '0px', // Default padding value
							'description' => esc_html__( 'Enter border bootom: (e.g., 0px)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name'=>esc_html__('Border Bottom Color','hostiko'),
							'id'=>'hostiko_nav_border_bottom_color',
							'default'=> esc_html__('#82828252','hostiko'),
							'transport'	=> 'refresh'  
						),

					) 
				),

				// Live Chat Settings
				'hostiko_live_chat_setting' => array(
					'name' => esc_html__( 'Live Chat', 'hostiko' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Apply Style', 'hostiko' ),
							'id' => 'hostiko_show_live_chat_btn',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name'=>esc_html__('Background Color','hostiko'),
							'id'=>'hostiko_live_bg',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Color','hostiko'),
							'id'=>'hostiko_live_color',
							'default'=> esc_html__('#','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Border Color','hostiko'),
							'id'=>'hostiko_live_border',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Border Radius', 'hostiko' ),
							'id' => 'hostiko_live_chat_br',
							'type' => 'text', // Single text input
							'default' => '4px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						
						array(
							'name' => esc_html__( 'Padding', 'hostiko' ),
							'id' => 'hostiko_live_chat_padding',
							'type' => 'text', // Single text input
							'default' => '10px 10px 10px 10px', // Default padding value
							'description' => esc_html__( 'Enter padding in the format: top right bottom left (e.g., 10px 20px 30px 40px)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name'=>esc_html__('Border Hover Color','hostiko'),
							'id'=>'hostiko_live_border_hover',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Background Hover Color','hostiko'),
							'id'=>'hostiko_live_bg_hover',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Hover Color','hostiko'),
							'id'=>'hostiko_live_color_hover',
							'default'=> esc_html__('#000','hostiko'),
							'transport'	=> 'refresh'  
						),
					) 
				),


				// Cart Style Settings

				'hostiko_cart_icon_setting' => array(
					'name' => esc_html__( 'Cart Icon', 'hostiko' ),
					'priority' => 20,
					'fields' => array(
						array(
							'name' => esc_html__( 'Show Cart Icon', 'hostiko' ),
							'id' => 'hostiko_show_cart_icon_btn',
							'default' => 1,
							'type' => 'switch',
							'transport'	=> 'refresh' 
						),	
						array(
							'name'=>esc_html__('Background Color','hostiko'),
							'id'=>'hostiko_cart_icon_bg',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Color','hostiko'),
							'id'=>'hostiko_cart_icon_color',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Border Color','hostiko'),
							'id'=>'hostiko_cart_icon_border',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name' => esc_html__( 'Border Radius', 'hostiko' ),
							'id' => 'hostiko_cart_icon_br',
							'type' => 'text', // Single text input
							'default' => '4px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						
						array(
							'name' => esc_html__( 'Padding', 'hostiko' ),
							'id' => 'hostiko_cart_icon_padding',
							'type' => 'text', // Single text input
							'default' => '10px 10px 10px 10px', // Default padding value
							'description' => esc_html__( 'Enter padding in the format: top right bottom left (e.g., 10px 20px 30px 40px)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						

						array(
							'name'=>esc_html__('Border Hover Color','hostiko'),
							'id'=>'hostiko_cart_icon_border_hover',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Background Hover Color','hostiko'),
							'id'=>'hostiko_cart_icon_bg_hover',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Hover Color','hostiko'),
							'id'=>'hostiko_cart_icon_color_hover',
							'default'=> esc_html__('#000','hostiko'),
							'transport'	=> 'refresh'  
						),
					) 
				),


				// Cart Counter Style
				'hostiko_cart_counter_setting' => array(
					'name' => esc_html__( 'Cart Counter', 'hostiko' ),
					'priority' => 20,
					'fields' => array(
						
						array(
							'name'=>esc_html__('Background Color','hostiko'),
							'id'=>'hostiko_cart_counter_bg',
							'default'=> esc_html__('','hostiko'),
							'transport'	=> 'refresh'  
						),
						array(
							'name'=>esc_html__('Color','hostiko'),
							'id'=>'hostiko_cart_counter_color',
							'default'=> esc_html__('#000000','hostiko'),
							'transport'	=> 'refresh'  
						),
						
						array(
							'name' => esc_html__( 'Top', 'hostiko' ),
							'id' => 'hostiko_cart_counter_top',
							'type' => 'text', // Single text input
							'default' => '0px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
						array(
							'name' => esc_html__( 'Right', 'hostiko' ),
							'id' => 'hostiko_cart_counter_right',
							'type' => 'text', // Single text input
							'default' => '0px', // Default padding value
							'description' => esc_html__( 'Enter border radius in the format: (e.g., 4x)', 'hostiko' ),
							'transport' => 'refresh', // Ensure the setting is refreshed on change
						),
					) 
				),
			),
		)
	);

}

add_filter('hostiko_customizer_data', 'hostiko_customizer');