<?php
/**
 * Functions which enhance the theme by hooking into WordPress
 *
 * @package hostiko
 * @param array $classes Classes for the body element.
 * @return array
*/

if(!class_exists('Hostiko_Functions')){
	class Hostiko_Functions{
		private static $instance;

		public function __construct() {
			add_filter( 'body_class', array($this,'body_classes') );
			add_action( 'wp_head', array($this,'pingback_header') );
		}

		public static function getInstance(){
			if (null ==  self::$instance){
				self::$instance = new self();
			}
			return self::$instance;
		}

		public function body_classes($classes){
			// Adds a class of hfeed to non-singular pages.
			if ( ! is_singular() ) {
				$classes[] = 'hfeed';
			}

			// Adds a class of no-sidebar when there is no sidebar present.
			if ( ! is_active_sidebar( 'right-sidebar' ) ) {
				$classes[] = 'no-sidebar';
			}
			// Adds a class of no-sidebar when there is no sidebar present.
			if ( ! is_active_sidebar( 'right-sidebar-shop' ) ) {
				$classes[] = 'no-sidebar';
			}

			return $classes;
		}

		public function pingback_header(){
			if ( is_singular() && pings_open() ) {
				printf( '<link rel="pingback" href="%s">', esc_url( get_bloginfo( 'pingback_url' ) ) );
			}
		}
		

        public function link_pages(){
            $defaults = array(
                'before' => '<div class="wp-link-pages"><span>'.esc_html__('Pages:' ,'hostiko').'</span>',
                'after' => '</div>',
                'link_before' => '',
                'link_after' => '',
                'next_or_number' => 'number',
                'separator' => ' ',
                'pagelink' => '%',
                'echo' => 1
            );
            wp_link_pages($defaults);
        }	
	
	}//end class
}



/**
 * [ocdi_import_files description]
 * @return [type] [description]
 */
function ocdi_import_files() {
    return array(
             
        array(
            'import_file_name' => 'Hostiko Layout 90',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-90/hostiko-layout90-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-90/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-90/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-90/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-90/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 89',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-89/hostiko-layout89-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-89/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-89/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-89/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-89/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 88',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-88/hostiko-layout88-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-88/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-88/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-88/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-88/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 87',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-87/hostiko-layout87-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-87/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-87/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-87/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-87/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 86',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-86/hostiko-layout86-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-86/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-86/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-86/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-86/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 85',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-85/hostiko-layout85-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-85/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-85/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-85/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-85/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 84',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-84/hostiko-layout84-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-84/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-84/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-84/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-84/screenshot.png',
        ),         
         array(
            'import_file_name' => 'Hostiko Layout 83',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-83/hostiko-layout83-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-83/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-83/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-83/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-83/screenshot.png',
        ),        
         array(
            'import_file_name' => 'Hostiko Layout 82',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-82/hostiko-layout82-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-82/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-82/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-82/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-82/screenshot.png',
        ),        
         array(
            'import_file_name' => 'Hostiko Layout 81',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-81/hostiko-layout81-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-81/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-81/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-81/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-81/screenshot.png',
        ),        
         array(
            'import_file_name' => 'Hostiko Layout 80',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-80/hostiko-layout80-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-80/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-80/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-80/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-80/screenshot.png',
        ),        
         array(
            'import_file_name' => 'Hostiko Layout 79',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-79/hostiko-layout79-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-79/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-79/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-79/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-79/screenshot.png',
        ),
        array(
            'import_file_name' => 'Hostiko Layout 78',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-78/hostiko-layout78-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-78/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-78/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-78/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-78/screenshot.png',
        ),   
        array(
            'import_file_name' => 'Hostiko Layout 77',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-77/hostiko-layout77-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-77/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-77/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-77/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-77/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 76',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-76/hostiko-layout76-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-76/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-76/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-76/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-76/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 75',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-75/hostiko-layout75-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-75/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-75/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-75/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-75/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 74',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-74/hostiko-layout74-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-74/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-74/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-74/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-74/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 73',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-73/hostiko-layout73-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-73/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-73/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-73/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-73/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 72',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-72/hostiko-layout72-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-72/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-72/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-72/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-72/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 71',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-71/hostiko-layout71-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-71/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-71/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-71/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-71/screenshot.png',
        ),        
        array(
            'import_file_name' => 'Hostiko Layout 70',
            'categories' => array() ,
            'local_import_file'          => trailingslashit(get_template_directory()).'/demo/layout-70/hostiko-layout70-content.xml',
            'local_import_widget_file'   => trailingslashit(get_template_directory()).'/demo/layout-70/site-settings.json',
            'local_import_customizer_file' => trailingslashit(get_template_directory()).'/demo/layout-70/hostiko-customizer.dat',
            'local_import_options_file' => trailingslashit(get_template_directory()).'/demo/layout-70/exported-options.json',            
            'import_preview_image_url'   => get_template_directory_uri().'/demo/layout-70/screenshot.png',
        ),        
              
                 
    );
}
// add_filter( 'pt-ocdi/import_files', 'ocdi_import_files' );

/**
 * [ocdi_after_import_setup description]
 * @return [type] [description]
 */
function ocdi_after_import_setup() {

    $locations = get_theme_mod( 'nav_menu_locations' );
    if ( ! is_array( $locations ) ) {
        $locations = [];
    }

    // Example: Unassign all menus
    foreach ( $locations as $location => $menu_id ) {
        $locations[ $location ] = 0; // Unassign all menus
    }

    set_theme_mod( 'nav_menu_locations', $locations );

    // Optionally reassign menus to locations
    $new_menu_id = wp_get_nav_menu_object( 'Main Menu' )->term_id ?? 0; // Replace 'Main Menu' with your menu name
    if ( $new_menu_id ) {
        $locations['main-menu'] = $new_menu_id; // Reassign the main menu
    }

    set_theme_mod( 'nav_menu_locations', $locations );

    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    if ( $main_menu ) {
        // Assign the menu to the 'main-menu' location
        $locations = get_theme_mod( 'nav_menu_locations', [] );
        $locations['main-menu'] = (int) $main_menu->term_id;
        set_theme_mod( 'nav_menu_locations', $locations );

        // Force term relationship refresh by adding a temporary menu item
        wp_update_nav_menu_item( $main_menu->term_id, 0, [
            'menu-item-title'  => 'Temporary Item',
            'menu-item-type'   => 'custom',
            'menu-item-url'    => '#',
            'menu-item-status' => 'publish',
        ]);

        // Optionally, remove the temporary menu item after assigning
        $menu_items = wp_get_nav_menu_items( $main_menu->term_id );
        foreach ( $menu_items as $item ) {
            if ( $item->title === 'Temporary Item' ) {
                wp_delete_post( $item->ID, true );
            }
        }
    }

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    if ( $front_page_id ) {
        update_option( 'page_on_front', $front_page_id->ID );
    }

    if ( $blog_page_id ) {
        update_option( 'page_for_posts', $blog_page_id->ID );
    }

    update_option( 'show_on_front', 'page' );

    // Elementor specific action
    if ( file_exists( WP_PLUGIN_DIR . '/elementor/elementor.php' ) ) {
        do_action( 'akd_elementor_global' );
    }

    // Clear menu cache to ensure it's updated
    wp_delete_nav_menu_transients();

}
add_action( 'pt-ocdi/after_import', 'ocdi_after_import_setup' );