<?php
/**
 * Product Loop Start
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/loop/loop-start.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.3.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<?php
$akd_theme_admin_page = get_option( 'akd-framework-admin-page' );
$product_item_cols = 4;
if(isset($akd_theme_admin_page['opt-image-select-shop-grid'])){
    
    if($akd_theme_admin_page['opt-image-select-shop-grid'] == 'single'){
        $product_item_cols = 1;
    }
    else if($akd_theme_admin_page['opt-image-select-shop-grid'] == 'two-column'){
        $product_item_cols = 2;
    }
    else if($akd_theme_admin_page['opt-image-select-shop-grid'] == 'three-column'){
        $product_item_cols = 3;
    }
    else{
        $product_item_cols = 4;
    }
}
?>
<ul class="products columns-<?php echo esc_attr( is_shop() ? $product_item_cols : wc_get_loop_prop( 'columns' ) ); ?>">